% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalfit.R
\name{finalfit}
\alias{finalfit}
\alias{finalfit.lm}
\alias{finalfit.glm}
\alias{finalfit.coxph}
\title{Final output tables for common regression models}
\usage{
finalfit(
  .data,
  dependent = NULL,
  explanatory = NULL,
  explanatory_multi = NULL,
  random_effect = NULL,
  formula = NULL,
  model_args = list(),
  weights = NULL,
  cont_cut = 5,
  column = NULL,
  keep_models = FALSE,
  metrics = FALSE,
  add_dependent_label = TRUE,
  dependent_label_prefix = "Dependent: ",
  dependent_label_suffix = "",
  keep_fit_id = FALSE,
  ...
)

finalfit.lm(
  .data,
  dependent,
  explanatory,
  explanatory_multi = NULL,
  random_effect = NULL,
  model_args = NULL,
  weights = NULL,
  cont_cut = 5,
  column = FALSE,
  keep_models = FALSE,
  metrics = FALSE,
  add_dependent_label = TRUE,
  dependent_label_prefix = "Dependent: ",
  dependent_label_suffix = "",
  keep_fit_id = FALSE,
  ...
)

finalfit.glm(
  .data,
  dependent,
  explanatory,
  explanatory_multi = NULL,
  random_effect = NULL,
  model_args = NULL,
  weights = NULL,
  cont_cut = 5,
  column = FALSE,
  keep_models = FALSE,
  metrics = FALSE,
  add_dependent_label = TRUE,
  dependent_label_prefix = "Dependent: ",
  dependent_label_suffix = "",
  keep_fit_id = FALSE,
  ...
)

finalfit.coxph(
  .data,
  dependent,
  explanatory,
  explanatory_multi = NULL,
  random_effect = NULL,
  model_args = NULL,
  column = TRUE,
  cont_cut = 5,
  keep_models = FALSE,
  metrics = FALSE,
  add_dependent_label = TRUE,
  dependent_label_prefix = "Dependent: ",
  dependent_label_suffix = "",
  keep_fit_id = FALSE,
  ...
)
}
\arguments{
\item{.data}{Data frame or tibble.}

\item{dependent}{Character vector of length 1:  quoted name of dependent
variable. Can be continuous, a binary factor, or a survival object of form
\code{Surv(time, status)}.}

\item{explanatory}{Character vector of any length: quoted name(s) of
explanatory variables.}

\item{explanatory_multi}{Character vector of any length: quoted name(s) of a
subset of explanatory variables to generate reduced multivariable model
(must only contain variables contained in \code{explanatory}).}

\item{random_effect}{Character vector of length 1, either, (1) name of random
intercept variable, e.g. "var1", (automatically convered to "(1 | var1)");
or, (2) the full \code{lme4} specification, e.g. "(var1 | var2)". Note
parenthesis MUST be included in (2) but NOT included in (1).}

\item{formula}{an object of class "formula" (or one that can be coerced to 
that class). Optional instead of standard dependent/explanatory format. 
Do not include if using dependent/explanatory.}

\item{model_args}{List. A list of arguments to pass to 
\code{\link{lm}}, \code{\link{glm}}, \code{coxph}.}

\item{weights}{Character vector of length 1: quoted name of weights variable. 
Passed to \code{\link{summary_factorlist}}, \code{\link{lm}}, and \code{\link{glm}} 
to provide weighted summary table and regression (e.g. IPTW). If wish weighted regression
and non-weighted summary table, pass \code{weights} argument within \code{model_args}. 
Not available with surival dependent variable.}

\item{cont_cut}{Numeric: number of unique values in continuous variable at
which to consider it a factor.}

\item{column}{Logical: Compute margins by column rather than row.}

\item{keep_models}{Logical: include full multivariable model in output when
working with reduced multivariable model (\code{explanatory_multi}) and/or
mixed effect models (\code{random_effect}).}

\item{metrics}{Logical: include useful model metrics in output in
publication format.}

\item{add_dependent_label}{Add the name of the dependent label to the top
left of table.}

\item{dependent_label_prefix}{Add text before dependent label.}

\item{dependent_label_suffix}{Add text after dependent label.}

\item{keep_fit_id}{Keep original model output coefficient label (internal).}

\item{...}{Other arguments to pass to \code{\link{fit2df}}:
\code{estimate_name, digits, confint_type, confint_level,
confint_sep}.}
}
\value{
Returns a data frame with the final model table.
}
\description{
An "all-in-one" function that takes a single dependent variable with a vector
of explanatory variable names (continuous or categorical variables) to
produce a final table for publication including summary statistics. The
appropriate model is selected on the basis of dependent variable and whether
a random effect is specified.

\code{finalfit.lm} method (not called directly)

\code{finalfit.glm} method (not called directly)

\code{finalfit.coxph} method (not called directly)
}
\examples{
library(finalfit)
library(dplyr)

# Summary, univariable and multivariable analyses of the form:
# glm(depdendent ~ explanatory, family="binomial")
# lmuni(), lmmulti(), lmmixed(), glmuni(), glmmulti(), glmmixed(), glmmultiboot(),
#   coxphuni(), coxphmulti()

data(colon_s) # Modified from survival::colon
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = 'mort_5yr'
colon_s \%>\%
  finalfit(dependent, explanatory)

# Multivariable analysis with subset of explanatory
#   variable set used in univariable analysis
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
explanatory_multi = c("age.factor", "obstruct.factor")
dependent = "mort_5yr"
colon_s \%>\%
  finalfit(dependent, explanatory, explanatory_multi)

# Summary, univariable and multivariable analyses of the form:
# lme4::glmer(dependent ~ explanatory + (1 | random_effect), family="binomial")

explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
explanatory_multi = c("age.factor", "obstruct.factor")
random_effect = "hospital"
dependent = "mort_5yr"
# colon_s \%>\%
#   finalfit(dependent, explanatory, explanatory_multi, random_effect)

# Include model metrics:
colon_s \%>\%
  finalfit(dependent, explanatory, explanatory_multi,  metrics=TRUE)

# Summary, univariable and multivariable analyses of the form:
# survival::coxph(dependent ~ explanatory)

explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "Surv(time, status)"

colon_s \%>\%
  finalfit(dependent, explanatory)

# Rather than going all-in-one, any number of subset models can
# be manually added on to a summary_factorlist() table using finalfit.merge().
# This is particularly useful when models take a long-time to run or are complicated.

# Note requirement for fit_id=TRUE.
# `fit2df` is a subfunction extracting most common models to a dataframe.

explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = 'mort_5yr'
colon_s \%>\%
  finalfit(dependent, explanatory, metrics=TRUE)

explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
explanatory_multi = c("age.factor", "obstruct.factor")
random_effect = "hospital"
dependent = 'mort_5yr'

# Separate tables
colon_s \%>\%
  summary_factorlist(dependent, explanatory, fit_id=TRUE) -> example.summary

colon_s \%>\%
  glmuni(dependent, explanatory) \%>\%
  fit2df(estimate_suffix=" (univariable)") -> example.univariable

colon_s \%>\%
  glmmulti(dependent, explanatory) \%>\%
  fit2df(estimate_suffix=" (multivariable)") -> example.multivariable

# Edited as CRAN slow to run these
# colon_s \%>\%
#   glmmixed(dependent, explanatory, random_effect) \%>\%
#   fit2df(estimate_suffix=" (multilevel") -> example.multilevel

# Pipe together
example.summary \%>\%
  finalfit_merge(example.univariable) \%>\%
  finalfit_merge(example.multivariable, last_merge = TRUE)
# finalfit_merge(example.multilevel)
}
\concept{finalfit all-in-one functions}
