% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_column_totals.R
\name{ff_column_totals}
\alias{ff_column_totals}
\alias{finalfit_column_totals}
\title{Add column totals to \code{summary_factorlist()} output}
\usage{
ff_column_totals(df.in, .data, dependent, percent = TRUE, digits = 1,
  label = NULL, prefix = "")

finalfit_column_totals(df.in, .data, dependent, percent = TRUE,
  digits = 1, label = NULL, prefix = "")
}
\arguments{
\item{df.in}{\code{summary_factorlist()} output.}

\item{.data}{Data frame used to create \code{summary_factorlist()}.}

\item{dependent}{Character. Name of dependent variable.}

\item{percent}{Logical. Include percentage.}

\item{digits}{Integer length 1. Number of digits for percentage.}

\item{label}{Character. Label for total row.}

\item{prefix}{Character. Prefix for column totals, e.g "N=".}
}
\value{
Data frame.
}
\description{
Add column totals to \code{summary_factorlist()} output
}
\examples{
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = 'mort_5yr'
colon_s \%>\% 
 summary_factorlist(dependent, explanatory) \%>\% 
 ff_column_totals(colon_s, dependent)

# Ensure works with missing data in dependent
colon_s = colon_s \%>\% 
 dplyr::mutate(
  mort_5yr = forcats::fct_explicit_na(mort_5yr)
 )
 colon_s \%>\% 
 summary_factorlist(dependent, explanatory) \%>\% 
 ff_column_totals(colon_s, dependent)
}
