% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_compare.R
\name{boot_compare}
\alias{boot_compare}
\title{Compare bootstrapped distributions}
\usage{
boot_compare(bs.out, confint_sep = " to ", comparison = "difference",
  condense = TRUE, compare_name = NA, digits = c(2, 3), ref_symbol = 1)
}
\arguments{
\item{bs.out}{Output from \code{boot::boot},}

\item{confint_sep}{String separating lower and upper confidence interval}

\item{comparison}{Either "difference" or "ratio".}

\item{condense}{Logical. FALSE gives numeric values, usually for plotting.
TRUE gives table for final output.}

\item{compare_name}{Name to be given to comparison metric.}

\item{digits}{Rounding for estimate values and p-values, default c(2,3).}

\item{ref_symbol}{Reference level symbol}
}
\value{
A dataframe of first differences or ratios for boostrapped distributions of a metric of interest.

\code{finalfit} predict functions
}
\description{
Not usually called directly. Included in \code{\link{boot_predict}}. Usually used in combination with A function that takes the output from \code{\link{summary_factorlist}(...,
fit_id=TRUE)} and merges with any number of model dataframes, usually
produced with a model wrapper followed by the \code{\link{fit2df}()} function
(see examples).
}
\examples{
# See boot_predict.
}
\seealso{
\code{\link{boot_predict}} \code{\link{finalfit_newdata}}
}
