% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-extract-nums.R
\name{extract_numbers}
\alias{extract_numbers}
\alias{nth_number}
\alias{first_number}
\alias{last_number}
\title{Extract numbers from a string.}
\usage{
extract_numbers(string, leave_as_string = FALSE, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE)

nth_number(string, n, leave_as_string = FALSE, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE)

first_number(string, leave_as_string = FALSE, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE)

last_number(string, leave_as_string = FALSE, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE)
}
\arguments{
\item{string}{A string.}

\item{leave_as_string}{Do you want to return the number as a string (\code{TRUE})
or as numeric (\code{FALSE}, the default)?}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{n}{The index of the number (or non-numeric) that you seek. Negative
indexing is allowed i.e. \code{n = 1} (the default) will give you the first
number (or non-numeric) whereas \code{n = -1} will give you the last number (or
non-numeric), \code{n = -2} will give you the second last number and so on. The
function is vectorized over this argument.}
}
\description{
See \code{\link[strex:str_extract_numbers]{strex::str_extract_numbers()}}.
}
