# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Paste a vector of strings into a single string.
#'
#' Paste a vector of strings together with a specified separator.
#'
#' @param strings A character vector of strings.
#' @param collapse A string.
#'
#' @return A string.
#'
#' @examples
#' paste_collapse(c("abc", "def"), collapse = "_")
#'
#' @noRd
paste_collapse <- function(strings, collapse) {
    .Call(`_filesstrings_paste_collapse`, strings, collapse)
}

#' Apply paste collapse to each element of a list.
#'
#' This is the same as doing
#' `sapply(char.list, paste, collapse = collapse)`, it's just faster.
#'
#' @param char_list A list of character vectors.
#' @param collapse A string.
#'
#' @return A list of character vectors.
#'
#' @examples
#' paste_collapse_list_elems(list(1:3, c("a", 5, "rory")), collapse = "R")
#'
#' @noRd
paste_collapse_list_elems <- function(char_list, collapse = "") {
    .Call(`_filesstrings_paste_collapse_list_elems`, char_list, collapse)
}

#' Remove empty strings from a character list.
#'
#' @param char_list A list of character vectors.
#'
#' @return A list of character vectors.
#'
#' @examples
#' str_list_remove_empties(list(c("a", "", "b"), "gg", c("", 1, "")))
#'
#' @noRd
str_list_remove_empties <- function(char_list) {
    .Call(`_filesstrings_str_list_remove_empties`, char_list)
}

#' Get the nth element of each vector in a list of numeric or character
#' vectors.
#'
#' These are faster implementations of procedures that could very easily be
#' done with [purrr::map_dbl] or [purrr::map_chr].
#'
#' This is a wrapper function for [str_list_nth_elems_()] that
#' has better error handling.
#'
#' @param char_list A list of character vectors.
#' @param n The index of the element that you want from each vector. If
#'   `char_list` is of length 1, this can be any length and those indices will
#'   be extracted from `char_list[[1]]`. Otherwise, this must either be of
#'   length 1 or the same length as `char_list`. All of this is to say that
#'   the function is vectorised over this argument.
#'
#' @return A list.
#'
#' @examples
#' str_list_nth_elems_(list(c("a", "b", "c"), c("d", "f", "a")), 2)
#' num_list_nth_elems_(list(1:5, 0:2), 4)
#'
#' @noRd
str_list_nth_elems_ <- function(char_list, n) {
    .Call(`_filesstrings_str_list_nth_elems_`, char_list, n)
}

#' @rdname str_list_nth_elems_
#' @param num_list A list of numeric vectors.
#' @noRd
num_list_nth_elems_ <- function(num_list, n) {
    .Call(`_filesstrings_num_list_nth_elems_`, num_list, n)
}

#' Interleave two vectors of strings.
#'
#' Make a vector of strings where the first element is from `strings1`, the
#' second is from `strings2`, the third is from `strings1`, the fourth is from
#' `strings2`, and so on.
#'
#' `strings1` and `strings2` must be the same length or differ in length only
#' by 1. If `strings2` is longer, it goes first.
#'
#' @param strings1,strings2 Character vectors.
#'
#' @return A character vector.
#'
#' @examples
#' interleave_strings(c("a", "c", "e"), c("b", "d"))
#'
#' @noRd
interleave_strings <- function(strings1, strings2) {
    .Call(`_filesstrings_interleave_strings`, strings1, strings2)
}

interleave_correctly_vec <- function(orig, strings1, strings2) {
    .Call(`_filesstrings_interleave_correctly_vec`, orig, strings1, strings2)
}

interleave_correctly <- function(orig, strings1, strings2) {
    .Call(`_filesstrings_interleave_correctly`, orig, strings1, strings2)
}

interleave_char_lists <- function(strings1, strings2) {
    .Call(`_filesstrings_interleave_char_lists`, strings1, strings2)
}

intmat_list_nrows <- function(intmat_list) {
    .Call(`_filesstrings_intmat_list_nrows`, intmat_list)
}

intmat_list_bind_nth_rows <- function(intmat_list, n) {
    .Call(`_filesstrings_intmat_list_bind_nth_rows`, intmat_list, n)
}

match_arg_index <- function(arg, choices) {
    .Call(`_filesstrings_match_arg_index`, arg, choices)
}

int_lst_first_col <- function(x) {
    .Call(`_filesstrings_int_lst_first_col`, x)
}

str_elems <- function(strings, locations) {
    .Call(`_filesstrings_str_elems`, strings, locations)
}

lst_df_pos_brace <- function(positions, braces) {
    .Call(`_filesstrings_lst_df_pos_brace`, positions, braces)
}

lst_char_to_num <- function(x) {
    .Call(`_filesstrings_lst_char_to_num`, x)
}

