% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{NiceFileNums}
\alias{NiceFileNums}
\title{Make file numbers comply with alphabetical order}
\usage{
NiceFileNums(dir = ".", pattern = NA)
}
\arguments{
\item{dir}{Path (relative or absolute) to the directory in which to do the
renaming (default is current working directory).}

\item{pattern}{A regular expression. If specified, files to be renamed are
restricted to ones matching this pattern (in their name).}
}
\value{
A logical vector with a \code{TRUE} for each successful rename
(should be all TRUEs) and \code{FALSE}s otherwise.
}
\description{
If files are numbered, their numbers may not \emph{comply} with alphabetical
order, i.e. "file2.ext" comes after "file10.ext" in alphabetical order. This
function renames the files in the specified directory such that they comply
with alphabetical order, so here "file2.ext" would be renamed to
"file02.ext".
}
\details{
It works on file names with more than one number in them e.g.
"file01part3.ext" (a file with 2 numbers). All the file names that it works
on must have the same number of numbers, and the non-number bits must be the
same. One can limit the renaming to files matching a certain pattern. This
function wraps \code{\link[=NiceNums]{NiceNums()}}, which does the string operations, but
not the renaming. To see examples of how this function works, see the
examples in that function's documentation.
}
\examples{
setwd(tempdir())
dir.create("NiceFileNums_test")
setwd("NiceFileNums_test")
files <- c("1litres_1.txt", "1litres_30.txt", "3litres_5.txt")
file.create(files)
NiceFileNums()
NiceFileNums(pattern = "\\\\.txt$")
setwd("..")
RemoveDirs("NiceFileNums_test")
}
