## ----setup, echo=FALSE---------------------------------------------------
  library(knitr)
  opts_knit$set(root.dir=tempdir())

## ----message=FALSE-------------------------------------------------------
library(filematrix)
fm = fm.create(filenamebase = "fmatrix", nrow = 50, ncol = 50, type = "double")

## ----comment=""----------------------------------------------------------
cat(readLines("fmatrix.desc.txt"), sep = "\n")

## ------------------------------------------------------------------------
fm[1:3, 1:2] = 1:6
fm[1:4, 1:3]
colSums(fm[,1:4])

## ------------------------------------------------------------------------
fm[1:4]
fm[51:54]

## ------------------------------------------------------------------------
colnames(fm) = paste0("Col", 1:ncol(fm))
rownames(fm) = paste0("Row", 1:nrow(fm))

## ------------------------------------------------------------------------
close(fm)

## ------------------------------------------------------------------------
fm = fm.open(filenamebase = "fmatrix", readonly = FALSE)

## ------------------------------------------------------------------------
mat = fm.load("fmatrix")

## ------------------------------------------------------------------------
matrix(1:12,3,4)

## ------------------------------------------------------------------------
dim(fm)
fm$appendColumns(nrow(fm):1)
fm$appendColumns(1:nrow(fm))
dim(fm)
fm[nrow(fm)+(-1:0), ncol(fm)+(-1:0)]


## ------------------------------------------------------------------------
closeAndDeleteFiles(fm)

