library(filehash)

######################################################################
## Test everything on all database formats

types <- c("DB1", "DB", "RDS")
set.seed(1000)

for(type in types) {
    cat("-----------------\n")
    cat("-----------------\n")
    cat("TESTING TYPE", type, "\n")
    cat("-----------------\n")
    cat("-----------------\n")

    name <- paste("mydb", type, sep = "")
    dbCreate(name, type)
    db <- dbInit(name, type)

    dbInsert(db, "a", 1:10)  ## integer
    dbInsert(db, "b", rnorm(100))  ## numeric
    dbInsert(db, "c", 100:1)  ## integer
    dbInsert(db, "d", runif(1000))  ## numeric
    dbInsert(db, "other", "hello")  ## character

    ## Use extractor/replacement methods
    db$list <- as.list(1:100)
    db$dataf <- data.frame(x = rnorm(2000), y = rnorm(2000), z = rnorm(2000))

    show(db)

    str(db$dataf)
    str(db$list)
    print(db$d)
    print(db$a)
    print(db$b)
    print(db$c)
    print(db$other)
        
    env <- db2env(db)
    ls(env)
    
    print(env$a)
    print(env$b)
    print(env$c)
    str(env$d)
    print(env$other)

    env$b <- rnorm(100)
    mean(env$b)
    
    env$a[1:5] <- 5:1
    print(env$a)

    with(db, print(mean(b)))

    r <- lapply(db, summary)
    str(r)

    dbDelete(db, "c")

    tryCatch(print(env$c), error = function(e) print(e))
    tryCatch(dbFetch(db, "c"), error = function(e) print(e))
    
    numbers <- rnorm(100)
    dbInsert(db, "numbers", numbers)
    b <- dbFetch(db, "numbers")
    stopifnot(all.equal(numbers, b))
    stopifnot(identical(numbers, b))
}

