% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions.r
\name{build.page}
\alias{build.page}
\title{build.page}
\usage{
build.page(
  interior.h = c(1),
  interior.w = c(1),
  ncol = 1,
  nrow = 1,
  interior,
  test.dim = FALSE,
  page.height = 8.5,
  page.width = 11,
  right.margin = 0.75,
  left.margin = 0.75,
  top.margin = 1.4 - 0.5,
  bottom.margin = 1.75 - 0.5,
  pos = 1,
  envir = as.environment(pos)
)
}
\arguments{
\item{interior.h}{a vector summing to 1 to indicate how to partition the heights (build.page)}

\item{interior.w}{a vector summing to 1 to indicate how to partition the widths (build.page)}

\item{ncol}{number of columns for the grid of graphics being built by build.page}

\item{nrow}{number of rows for the grid of graphics being built by build.page}

\item{interior}{a list of nrow*ncol grobs/ggplot objects to be displayed in the grid, ordered by row then col (build.page)}

\item{test.dim}{logical. Assists with figure development. If TRUE it makes a call to grid.show.layout.}

\item{page.height}{used by build.page and annotate.page; presumed to be inches}

\item{page.width}{used by build.page and annotate.page; presumed to be inches}

\item{right.margin}{used by build.page and annotate.page; presumed to be inches}

\item{left.margin}{used by build.page and annotate.page; presumed to be inches}

\item{top.margin}{used by build.page and annotate.page; presumed to be inches}

\item{bottom.margin}{used by build.page and annotate.page}

\item{pos}{used internally by some functions}

\item{envir}{used internally by some functions}
}
\value{
This writes graphics/grobs to a device.
}
\description{
Takes page dimensions, figure layout dimensions and an ordered list of grobs/ggplot objects orients them on a page
}
\examples{
{
# Commenting out calls to pdf and dev.off.
# pdf(file = "demonstrating build.page.pdf", width = 11, height = 8.5)
build.page(test.dim= TRUE)
build.page(interior.w = c(.5, .5), ncol=2, nrow=1, test.dim= TRUE)
build.page(interior.h = c(.5, .5), ncol=1, nrow=2, test.dim= TRUE)
build.page(interior.h = c(.5, .5), interior.w = c(.5, .5), ncol=2, nrow=2, test.dim= TRUE)
build.page(interior.h=c(1/3,1/3,1/3),
           interior.w=c(1),
           ncol=1, nrow=3,
           test.dim=TRUE)
build.page(interior.h=c(2, 1, 3)/6,
           interior.w=c(.6, .4),
           ncol=2, nrow=3,
           test.dim=TRUE)
build.page(interior.h=c(1/3,1/3,1/3),
           interior.w=c(.5, .5),
           ncol=2, nrow=3,
           test.dim=TRUE,
           top.margin=.1,
           bottom.margin=.1,
           right.margin=.1,
           left.margin=.1)

parabola.up <- ggplot2::ggplot(data.frame(x=-10:10, y=(-10:10)^2), ggplot2::aes(x=x,y=y))+
ggplot2::geom_line()
parabola.down <- ggplot2::ggplot(data.frame(x=-10:10, y=-(-10:10)^2), ggplot2::aes(x=x,y=y))+
ggplot2::geom_line()
cubic.up <- ggplot2::ggplot(data.frame(x=-10:10, y=(-10:10)^3), ggplot2::aes(x=x,y=y))+
ggplot2::geom_line()
cubic.down <- ggplot2::ggplot(data.frame(x=-10:10, y=-(-10:10)^3), ggplot2::aes(x=x,y=y))+
ggplot2::geom_line()

red.parabola.up <- ggplot2::ggplot(data.frame(x=-10:10, y=(-10:10)^2), ggplot2::aes(x=x,y=y))+
ggplot2::geom_line(color="red")
red.parabola.down <- ggplot2::ggplot(data.frame(x=-10:10, y=-(-10:10)^2), ggplot2::aes(x=x,y=y))+
ggplot2::geom_line(color="red")
red.cubic.up <- ggplot2::ggplot(data.frame(x=-10:10, y=(-10:10)^3), ggplot2::aes(x=x,y=y))+
ggplot2::geom_line(color="red")
red.cubic.down <- ggplot2::ggplot(data.frame(x=-10:10, y=-(-10:10)^3), ggplot2::aes(x=x,y=y))+
ggplot2::geom_line(color="red")



build.page(interior.h = c(.5, .5), nrow=2, ncol=1,
           test.dim= FALSE, interior = list(parabola.up, 
                                       parabola.down))

build.page(interior.w = c(.5, .5), nrow=1, ncol=2,
           test.dim= FALSE, interior = list(parabola.up, 
                                       parabola.down))

build.page(interior.w = c(.5, .5), interior.h = c(.5, .5), nrow=2, ncol=2,
           test.dim= FALSE, interior = list(parabola.up, 
                                       red.parabola.up,
                                       parabola.down, 
                                       red.parabola.down
                                       ))

build.page(interior.h=c(1/3,1/3,1/3),
           interior.w=c(1),
           ncol=1, nrow=3,
           interior = list(parabola.up, 
                           parabola.down,
                           cubic.up
           ))

build.page(interior.w=c(1/3,1/3,1/3),
           interior.h=c(1),
           ncol=3, nrow=1,
           interior = list(parabola.up, 
                           parabola.down,
                           cubic.up
           ))

build.page(interior.h=c(2, 1, 3)/6,
           interior.w=c(.6, .4),
           ncol=2, nrow=3,
           interior = list(parabola.up, 
                parabola.down,
                cubic.up,
                cubic.down, 
                red.parabola.down,
                red.cubic.down)
           )

build.page(interior.h=c(1/3, 1/3, 1/3),
           interior.w=c(.5, .5),
           ncol=2, nrow=3,
           interior = list(parabola.up,
                           parabola.down,
                           cubic.up,
                           cubic.down, 
                           red.parabola.down,
                           red.cubic.down)
)


build.page(interior.h=c(1/3,1/3,1/3),
           interior.w=c(.5, .5),
           ncol=2, nrow=3,
           top.margin=.1,
           bottom.margin=.1,
           right.margin=.1,
           left.margin=.1,
           interior = list(parabola.up,
                           parabola.down,
                           cubic.up,
                           cubic.down, 
                           red.parabola.down,
                           red.cubic.down))


# dev.off()

} 
}
\author{
Greg Cicconetti
}
