% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url.R
\name{build_request_url}
\alias{build_request_url}
\title{Build the request URL}
\usage{
build_request_url(base_url, path = NULL, ...)
}
\arguments{
\item{base_url}{A single string with the base URL that you want add components to;}

\item{path}{A vector of strings (or a single string) with "path" components;}

\item{...}{Key-value pairs that will compose the query string section of the URL;}
}
\value{
A single string with the complete URL.
}
\description{
Add multiple "components" to a base URL, to build
the complete URL that will be used in the HTTP request (non-exported function).
}
\details{
This function receives as input, a set of pieces (or components) of
the URL that will be used in the HTTP request. Then, it tries to combine
(or "collapse") all these pieces together to form a single string with
the complete URL.

There are three main types of pieces (or components) accepted by this function.
First, the base URL, which is the initial portion of the URL. Usually, this is
the base URL for the Figma API.

Second, we have the "path" components,
which are all the small bits that compose the path and resource sections
of the URL. Each element of the vector given to \code{path} is separated
by a slash character (\code{"/"}) in the final result.

For example, if I give the vector \code{c("path1", "path2", "path3")}
to \code{path}, the end result will be structured like this:

\code{base_url/path1/path2/path3}

Third, a query string, which is usually composed by a set of
key-value pairs. \code{build_request_url()} collects all these
key-value pairs through the \code{...} argument, and then, combines
all these pairs together to form a query string.
}
