% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.interaction.R
\name{imageInteraction}
\alias{imageInteraction}
\title{Plot an two-way quantitative interaction in an image plot}
\usage{
imageInteraction(data, x, y, z, plot = TRUE, legend = TRUE, ...)
}
\arguments{
\item{data}{a data matrix with columns indicating the values of x, y, and z}

\item{x}{the name of the x variable (a string)}

\item{y}{the name of the y variable (a string)}

\item{z}{the name of the z variable (a string)}

\item{plot}{Should an image be plotted?}

\item{legend}{add a legend to the plot?}

\item{...}{other arguments passed to \code{\link{anchored.gradient}}.}
}
\value{
the x range, y range, and image matrix
}
\description{
Plot an two-way quantitative interaction in an image plot
}
\details{
The \code{\link{image}} function is quite useful for displaying two-way quantitative interactions (variable X on the X axis,
variable Y on the Y axis, and z represented as a color). However, this function requires a matrix where the cells (r_ij) represent the Z value
in the ith value of x and jth value of y. Getting it into matrix form can be annoying if it natively comes in long-column format. This function
takes a data matrix, conditions as well as z in the columns, and returns an image matrix.
}
\examples{
## do this later
}
\author{
Dustin Fife
}
\seealso{
\code{\link{image}}
}

