\name{mv.rnorm}
\alias{mv.Rnorm}
\alias{mv.rnorm}
\alias{mvrnorm}
\title{Randomly Generate Multivariate Normal Data}
\usage{
  mv.rnorm(n = 1, vars = NULL, mu = NULL, Sigma = NULL,
    names = NULL)
}
\arguments{
  \item{n}{The sample size of the randomly generated
  dataset}

  \item{vars}{An integer indicating the number of
  variables. Ignored unless no \code{Sigma} is supplied.}

  \item{mu}{A vector of means that has the same length as
  the number of rows/columns of Sigma. Defaults to a vector
  of zeroes.}

  \item{Sigma}{A positive definate matrix. If \code{NULL},
  the user must specify \code{vars}.}

  \item{names}{Optional. A vector of strings indicating the
  variable names.}
}
\value{
  a nxp matrix of pseuodo-random values.
}
\description{
  This function will randomly generate correlated
  multivariate normal data with specified means and
  covariances (or correlations). The user also has the
  flexibility to generate data with a randomly selected
  correlation matrix using the
  \code{\link{random.correlation}} function.
}
\details{
  \code{mv.norm} generates correlated multivariate normal
  data using a choleski decomposition. If the user does not
  specify \code{Sigma}, a random correlation matrix will be
  generated. Also, if means are not specified, the function
  will default to means of zero.
}
\examples{
set.seed(2)
## generate data with correlation of .6
d = mv.rnorm(n=1000, Sigma=matrix(c(1, .6, .6, 1), 2), names=c("x", "y"))
head(d); cor(d)
## generate data with a random correlation
d = mv.rnorm(n=1000, vars=4, names=letters[1:4])
head(d); cor(d)
## generate non-scaled data
ms = c(100, 10, 5, 0) ### specify means
Sigma = matrix(c(1, .6, .5, .4,
			.6, 1, .3, .2,
			.5, .3, 1, .1,
			.4, .2, .1, 1), 4)
## convert Sigma to covariance matrix
Sigma = cor2cov(Sigma, sd=c(15, 3, 2, 1))
## generate the data
d = mv.rnorm(n=1000, mu=ms, Sigma=Sigma, names=letters[1:4])
head(d); cor(d)
}
\author{
  Dustin Fife
}
\seealso{
  \code{\link{random.correlation}} \code{\link{cor2cov}}
}

