\name{SummarizeFactorDefault}
\alias{SummarizeFactorDefault}
\title{Summarize a factor vector with count and percentages}
\usage{
  SummarizeFactorDefault(x, group = rep(1, length(x)),
    decimal = 0, latex = TRUE, useNA = "ifany", ...)
}
\arguments{
  \item{x}{Vector of values.}

  \item{group}{Group identifier to return summaries by
  group.}

  \item{decimal}{The number of decimal values to format the
  results; defaults to 0.}

  \item{latex}{Return LaTeX characters if \code{TRUE}
  (default). For example, the LaTeX code for the percentage
  symbol should be preceeded by the escape character
  \code{\}}.}

  \item{useNA}{Defaults to \code{ifany} and passed to
  \code{\link{table}}.}

  \item{...}{Nothing.}
}
\value{
  Formatted text of counts with percentages in parentheses,
  in a vector or matrix.
}
\description{
  Summarize a factor variable with count and percentages.
}
\details{
  Default \code{factor.summary.function} for use in
  \code{\link{SummarizeVar}}. Returns formatted text of
  count and percentages. For use in construction of
  demographics tables.
}
\examples{
SummarizeFactorDefault(x=c(sample(1:5, 100, replace=TRUE), sample(1:5, 100, replace=TRUE)),
  group=rep(0:1, each=100))
}
\author{
  Vinh Nguyen
}

