% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_main_stem.R
\name{pick_main_stem}
\alias{pick_main_stem}
\alias{pick_main_stemid}
\title{Pick the main stem or main stemid(s) of each tree in each census.}
\usage{
pick_main_stem(data)

pick_main_stemid(data)
}
\arguments{
\item{data}{A ForestGEO-like dataframe: A \emph{ViewFullTable}, \emph{tree} or \emph{stem}
table.}
}
\value{
A dataframe with a single plotname, and one row per per treeid per
censusid.
}
\description{
\itemize{
\item \code{\link[=pick_main_stem]{pick_main_stem()}} picks a unique row for each \code{treeID} per census.
\item \code{\link[=pick_main_stemid]{pick_main_stemid()}} picks a unique row for each \code{stemID} per census. It is
only useful when a single stem was measured twice in the same census, which
sometimes happens to correct for the effect of large buttresses.
}
}
\details{
\itemize{
\item \code{\link[=pick_main_stem]{pick_main_stem()}} picks the main stem of each tree in each census. It
collapses data of multi-stem trees by picking a single stem per \code{treeid} per
\code{censusid}. From this group, it picks the stem at the top of a list sorted
first by descending order of \code{hom} and then by descending order of \code{dbh}.
This this corrects the effect of buttresses and picks the main stem. It
ignores groups of grouped data and rejects data with multiple plots.
\item \code{\link[=pick_main_stemid]{pick_main_stemid()}} does one step less than \code{\link[=pick_main_stem]{pick_main_stem()}}. It only
picks the main stemid(s) of each tree in each census and keeps all stems per
treeid. This is useful when calculating the total basal area of a tree,
because you need to sum the basal area of each individual stem as well as sum
only one of the potentially multiple measurements of each buttressed stem per
census.
}
}
\section{Warning}{

These functions may be considerably slow. They are fastest if the data
already has a single stem per treeid. They are slower with data containing
multiple stems per \code{treeid} (per \code{censusid}), which is the main reason for
using this function. The slowest scenario is when data also contains
duplicated values of \code{stemid} per \code{treeid} (per \code{censusid}). This may
happen if trees have buttresses, in which case these functions check
every stem for potential duplicates and pick the one with the largest \code{hom}
value.

For example, in a windows computer with 32 GB of RAM, a dataset with 2
million rows with multiple stems and buttresses took about 3 minutes to run.
And a dataset with 2 million rows made up entirely of main stems took about
ten seconds to run.
}

\examples{
# One `treeID` with multiple stems. 
# `stemID == 1.1` has two measurements (due to buttresses).
# `stemID == 1.2` has a single measurement.
census <- tribble(
    ~sp, ~treeID, ~stemID,  ~hom, ~dbh, ~CensusID,
  "sp1",     "1",   "1.1",   140,   40,         1,  # main stemID (max `hom`)
  "sp1",     "1",   "1.1",   130,   60,         1,  
  "sp1",     "1",   "1.2",   130,   55,         1   # main stemID (only one)
)

# Picks a unique row per unique `treeID`
pick_main_stem(census)

# Picks a unique row per unique `stemID`
pick_main_stemid(census)

}
\seealso{
Other functions to pick or drop rows of a ForestGEO dataframe: \code{\link{pick_drop}}
}
\concept{functions to pick or drop rows of a ForestGEO dataframe}
