% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_ffgrid.R
\name{expand.ffgrid}
\alias{expand.ffgrid}
\title{Create a \code{ffdf} from All Combinations of Factors}
\usage{
expand.ffgrid(..., KEEP.OUT.ATTRS = TRUE, stringsAsFactors = TRUE)
}
\arguments{
\item{...}{\code{ff} vectors, \code{ff} factors or a list containing these.}

\item{KEEP.OUT.ATTRS}{currently ignored}

\item{stringsAsFactors}{logical specifying if character vectors are converted to factors. Irrelevant for \code{ff} as character vectors are factors in 
package ff.}
}
\value{
A \code{ffdf} containing one row for each combination of the supplied factors. The first factors vary fastest. 
The columns are labelled by the factors if these are supplied as named arguments or named components of a list.
}
\description{
Similar as \code{expand.grid} in the base package generates an \code{ffdf}.
Code is almost copy-pasted from \code{\link[base]{expand.grid}}.
}
\examples{
comb <- expand.ffgrid(ff(1:1000), ff(factor(LETTERS)))
dim(comb)

x <- ff(factor(LETTERS))
y <- ff(1:1000)
z <- ff(seq.Date(Sys.Date(), Sys.Date()+10, by = "day"))
comb <- expand.ffgrid(x, y, z)
dim(comb)
comb[1:100, ]

expand.ffgrid(list(a = ff(1:10), b = ff(1:10)))

}
\seealso{
\code{\link[base]{expand.grid}}
}

