% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-pipe-sine.R
\docType{data}
\name{sine1000}
\alias{sine1000}
\alias{sine1000_8d}
\alias{pipe1000}
\alias{pipe1000_8d}
\alias{pipe1000_10d}
\alias{pipe1000_12d}
\alias{boa}
\alias{boa5}
\alias{boa6}
\title{Simulated sine, pipe, and gaussian mixture}
\format{
An object of class \code{matrix} (inherits from \code{array}) with 1000 rows and 6 columns.

An object of class \code{matrix} (inherits from \code{array}) with 1000 rows and 8 columns.

An object of class \code{matrix} (inherits from \code{array}) with 1000 rows and 6 columns.

An object of class \code{matrix} (inherits from \code{array}) with 1000 rows and 8 columns.

An object of class \code{matrix} (inherits from \code{array}) with 1000 rows and 10 columns.

An object of class \code{matrix} (inherits from \code{array}) with 1000 rows and 12 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1000 rows and 10 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1000 rows and 5 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1000 rows and 6 columns.
}
\usage{
sine1000

sine1000_8d

pipe1000

pipe1000_8d

pipe1000_10d

pipe1000_12d

boa

boa5

boa6
}
\description{
Simulated sine and pipe data for calculating optimisation features.
Each dataset has 1000 observations and the last two columns contain the
intended structure with the rest being noise.
}
\examples{
library(ggplot2)
library(tidyr)
library(dplyr)
boa \%>\%
  pivot_longer(cols = x1:x10, names_to = "var", values_to = "value") \%>\%
  mutate(var = forcats::fct_relevel(as.factor(var), paste0("x", 1:10))) \%>\%
  ggplot(aes(x = value)) +
  geom_density() +
  facet_wrap(vars(var))

sine1000 |> ggplot(aes(x = V5, y = V6)) + geom_point() + theme(aspect.ratio = 1)
pipe1000_8d |> ggplot(aes(x = V5, y = V6)) + geom_point() + theme(aspect.ratio = 1)
pipe1000_8d |> ggplot(aes(x = V7, y = V8)) + geom_point() + theme(aspect.ratio = 1)
}
\keyword{datasets}
