% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{bind_random_matrix}
\alias{bind_random_matrix}
\title{Bind random bases in the projection bases space as a matrix}
\usage{
bind_random_matrix(basis, n = 500, front = FALSE, seed = 1)
}
\arguments{
\item{basis}{a matrix returned by \code{get_basis_matrix()}}

\item{n}{numeric; the number of random bases to generate in each dimension by geozoo}

\item{front}{logical; if the random bases should be bound before or after the original bases}

\item{seed}{numeric; a seed for generating reproducible random bases from geozoo}
}
\value{
matrix

a matrix containing both the searched and random bases
}
\description{
Bind random bases in the projection bases space as a matrix
}
\examples{
data <- get_basis_matrix(holes_1d_geo)
bind_random_matrix(data) \%>\% tail(5)
}
\seealso{
Other bind: 
\code{\link{bind_random}()},
\code{\link{bind_theoretical}()}
}
\concept{bind}
