% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_trace.R
\name{explore_trace_interp}
\alias{explore_trace_interp}
\title{Plot the trace the search progression}
\usage{
explore_trace_interp(
  dt,
  iter = NULL,
  color = NULL,
  group = NULL,
  cutoff = 50,
  target_size = 3,
  interp_size = 1,
  accuracy_x = 5,
  accuracy_y = 0.01
)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in \code{tourr}}

\item{iter}{the variable to be plotted on the x-axis}

\item{color}{the variable to be coloured by}

\item{group}{the variable to label different runs of the optimiser(s)}

\item{cutoff}{numeric; if the number of interpolating points is smaller than \code{cutoff}, all the interpolation points will be plotted as dots}

\item{target_size}{numeric; the size of target points in the interpolation}

\item{interp_size}{numeric; the size of interpolation points}

\item{accuracy_x}{numeric; If the difference of two neighbour x-labels is smaller than \code{accuracy_x}, only one of them will be displayed. Used for better axis label}

\item{accuracy_y}{numeric; the precision of y-axis label}
}
\value{
a ggplot object for diagnosing how the index value progresses during the interpolation
}
\description{
Trace the index value of search/ interpolation points in guided tour optimisation
}
\examples{
# Compare the trace of interpolated points in two algorithms
holes_1d_better \%>\%
  explore_trace_interp(interp_size = 2) +
  scale_color_continuous_botanical(palette = "fern")
}
\seealso{
Other main plot functions: 
\code{\link{explore_space_pca}()},
\code{\link{explore_space_tour}()},
\code{\link{explore_trace_search}()}
}
\concept{main plot functions}
