% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{metadata}
\alias{metadata}
\title{Get 'metadata' table}
\usage{
metadata(data.set, progress = TRUE, verbose = TRUE, febr.repo = NULL)
}
\arguments{
\item{data.set}{Character vector indicating the identification code of one or more data sets.
Use \code{data.set = "all"} to download all data sets.}

\item{progress}{(optional) Logical value indicating if a download progress bar should be displayed.}

\item{verbose}{(optional) Logical value indicating if informative messages should be displayed. Generally
useful to identify datasets with inconsistent data. Please report to \email{febr-forum@googlegroups.com}
if you find any issue.}

\item{febr.repo}{(optional) Defaults to the remote file directory of the Federal University of
Technology - Paraná at \url{https://cloud.utfpr.edu.br/index.php/s/Df6dhfzYJ1DDeso}.
Alternatively, a local directory path can be informed if the user has a local copy of the data
repository.}
}
\value{
A list of data frames or a data frame with metadata of the chosen dataset(s).
}
\description{
Download data from the 'metadata' ("metadado") table of one or more datasets
published in the \href{https://www.pedometria.org/febr/}{Data Repository of the Brazilian Soil}.
This table includes data such as variable names, description of analytical methods, and
identification of analysis laboratories.
}
\note{
Check the new core data download function \code{\link[=readFEBR]{readFEBR()}}.
}
\examples{
\donttest{
# res <- metadata(data.set = c("ctb0003", "ctb0020"))
res <- metadata(data.set = c("ctb0003", "ctb0002"))
}
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
