% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit.R
\name{unit}
\alias{unit}
\title{Get \emph{units} table}
\usage{
unit(source, target)
}
\arguments{
\item{source}{(optional) Character vector indicating one or more source measurement units.}

\item{target}{(optional) Character vector indicating one or more target measurement units.}
}
\value{
A data.frame with source and target measurement units and their corresponding conversion factors.
}
\description{
Download data from the \emph{units} ("unidades") table of the Free Brazilian Repository for Open Soil Data --
\emph{\strong{febr}}, \url{http://www.ufsm.br/febr}. This includes measurement units and conversion factors. This
is used to standardize the data contained in a dataset when downloading it via \code{\link[febr]{layer}} or
\code{\link[febr]{observation}}.
}
\examples{
res <- unit(source = c("\%", "dag/kg"), target = "g/kg")
res
}
\references{
Teixeira, P. C., Donagemma, G. K., Fontana, A., Teixeira, W. G. (2017)
\emph{Manual de Métodos de Análise de Solo}. Brasília: Embrapa.
}
\seealso{
The \emph{unit} table at
\url{https://docs.google.com/spreadsheets/d/1tU4Me3NJqk4NH2z0jvMryGObSSQLCvGqdLEL5bvOflo}
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
