% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorial.R
\name{CA}
\alias{CA}
\title{Correspondence Analysis (CA)}
\usage{
CA(
  d,
  ncp = 5,
  row.sup = NULL,
  col.sup = NULL,
  quanti.sup = NULL,
  quali.sup = NULL,
  row.w = NULL
)
}
\arguments{
\item{d}{A ddata frame or a table with n rows and p columns, i.e. a contingency table.}

\item{ncp}{The number of dimensions kept in the results (by default 5).}

\item{row.sup}{A vector indicating the indexes of the supplementary rows.}

\item{col.sup}{A vector indicating the indexes of the supplementary columns.}

\item{quanti.sup}{A vector indicating the indexes of the supplementary continuous variables.}

\item{quali.sup}{A vector indicating the indexes of the categorical supplementary variables.}

\item{row.w}{An optional row weights (by default, a vector of 1 for uniform row weights); the weights are given only for the active individuals.}
}
\value{
The CA on the dataset.
}
\description{
Performs Correspondence Analysis (CA) including supplementary row and/or column points.
}
\examples{
data (children, package = "FactoMineR")
CA (children, row.sup = 15:18, col.sup = 6:8)
}
\seealso{
\code{\link[FactoMineR]{CA}}, \code{\link{MCA}}, \code{\link{PCA}}, \code{\link{plot.factorial}}, \code{\link{factorial-class}}
}
