% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reparam_curve.R
\name{reparam_curve}
\alias{reparam_curve}
\title{Align two curves}
\usage{
reparam_curve(
  beta1,
  beta2,
  lambda = 0,
  method = "DP",
  w = 0.01,
  rotated = TRUE,
  isclosed = FALSE,
  mode = "O"
)
}
\arguments{
\item{beta1}{curve 1, provided as a matrix of dimensions \eqn{n \times M} for
\eqn{n}-dimensional curve evaluated on \eqn{M} sample points}

\item{beta2}{curve 1, provided as a matrix of dimensions \eqn{n \times M} for
\eqn{n}-dimensional curve evaluated on \eqn{M} sample points}

\item{lambda}{controls amount of warping (default = \code{0})}

\item{method}{controls which optimization method. Options are
Dynamic Programming (\code{"DP"}). (default = \code{"DP"})}

\item{w}{controls LRBFGS (default = \code{0.01})}

\item{rotated}{boolean if rotation is desired}

\item{isclosed}{boolean if curve is closed}

\item{mode}{Open (\code{"O"}) or Closed (\code{"C"}) curves}
}
\value{
return a List containing \item{gam}{warping function}
\item{R}{rotation matrix}
\item{tau}{seed point}
}
\description{
This function aligns two SRVF functions using Dynamic Programming. If the
curves beta1 and beta2 are describing multidimensional functional data, then
\code{rotation == FALSE} and \code{mode == 'O'}
}
\examples{
gam <- reparam_curve(beta[, , 1, 1], beta[, , 1, 5])$gam
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
