% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCCor.R
\name{FCCor}
\alias{FCCor}
\title{Calculate functional correlation between two simultaneously observed processes.}
\usage{
FCCor(x, y, Lt, bw = stop("bw missing"), kern = "epan",
  Tout = sort(unique(unlist(Lt))))
}
\arguments{
\item{x}{A list of function values corresponding to the first process.}

\item{y}{A list of function values corresponding to the second process.}

\item{Lt}{A list of time points for both \code{x} and \code{y}.}

\item{bw}{A numeric vector for bandwidth of length either 5 or 1, specifying the bandwidths for E(X), E(Y), var(X), var(Y), and cov(X, Y). If \code{bw} is a scalar then all five bandwidths are chosen to be the same.}

\item{kern}{Smoothing kernel for mu and covariance; "rect", "gauss", "epan", "gausvar", "quar" (default: "gauss")}

\item{Tout}{Output time points. Default to the sorted unique time points.}
}
\value{
A list with the following components:
\item{corr}{A vector of the correlation corr(X(t), Y(t)) evaluated at \code{Tout}.}
\item{Tout}{Same as the input Tout.}
\item{bw}{The bandwidths used for E(X), E(Y), var(X), var(Y), and cov(X, Y).}
}
\description{
Calculate functional correlation between two simultaneously observed processes.
}
\details{
\code{FCCor} calculate only the concurrent correlation corr(X(t), Y(t)) (note that the time points t are the same). It assumes no measurement error in the observed values.
}
\examples{
set.seed(1)
n <- 200
nGridIn <- 50
sparsity <- 1:5 # must have length > 1
bw <- 0.2
kern <- 'epan'
T <- matrix(seq(0.5, 1, length.out=nGridIn))

## Corr(X(t), Y(t)) = 1/2
A <- Wiener(n, T)
B <- Wiener(n, T) 
C <- Wiener(n, T) + matrix((1:nGridIn) , n, nGridIn, byrow=TRUE)
X <- A + B
Y <- A + C
indEach <- lapply(1:n, function(x) sort(sample(nGridIn, sample(sparsity, 1))))
tAll <- lapply(1:n, function(i) T[indEach[[i]]])
Xsp <- lapply(1:n, function(i) X[i, indEach[[i]]])
Ysp <- lapply(1:n, function(i) Y[i, indEach[[i]]])

plot(T, FCCor(Xsp, Ysp, tAll, bw)[['corr']], ylim=c(-1, 1))
abline(h=0.5)
}
