% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WFDA.R
\name{WFDA}
\alias{WFDA}
\title{Warped Functional DAta Analysis}
\usage{
WFDA(Ly, Lt, optns = list())
}
\arguments{
\item{Ly}{A list of \emph{n} vectors containing the observed values for each individual.}

\item{Lt}{A list of \emph{n} vectors containing the observation time points for each individual corresponding to y. Each vector should be sorted in ascending order.}

\item{optns}{A list of options control parameters specified by \code{list(name=value)}. See 'Details'.}
}
\value{
A list containing the following fields: 
\item{lambda}{Penalty parameter used.}
\item{aligned}{Aligned curves evaluated at time 't'}
\item{h}{Warping functions for 't'} 
\item{hInv}{Inverse warping functions evaluated at 't'} 
\item{costs}{The mean cost associated with each curve} 
\item{timing}{The time required by time-warping.}
}
\description{
Pairwise curve synchronization for functional data
}
\details{
WFDA uses a pairwise warping method to obtain the desired alignment (registration) of the random trajectories. 
The data has to be regular. The routine returns the aligned curves and the associated warping function. 

Available control options are 
\describe{
\item{choice}{Choice of estimating the warping functions ('weighted' or 'truncated'). If 'weighted' then weighted averages of pairwise warping functions are computed; the weighting is based on the inverse pairwise distances. If 'truncated' the pairs with the top 10\% largest distances are truncated and the simple average of the remaining pairwise distances are used - default: 'truncated'}
\item{subsetProp}{Pairwise warping functions are determined by using a subset of the whole sample; numeric (0,1] - default: 0.50}
\item{lambda}{Penalty parameter used for estimating pairwise warping functions; numeric - default : V*10^-4, where V is the average L2 norm of y-mean(y).}
\item{nknots}{Number of knots used for estimating the piece-wise linear pairwise warping functions; numeric - default: 2} 
\item{isPWL}{Indicator if the resulting warping functions should piece-wise linear, if FALSE 'nknots' is ignored and the resulting warping functions are simply monotonic; logical - default: TRUE (significantly larger computation time.)} 
\item{seed}{Random seed for the selection of the subset of warping functions; numeric - default: 666}
\item{verbose}{Indicator if the progress of the pairwise warping procedure should be displayed; logical - default: FALSE}
}
}
\examples{
N = 44;
eps = 0.123;
M = 41;
set.seed(123) 
Tfinal = 3
me <- function(t) exp(-Tfinal*(((t/Tfinal^2)-0.5))^2);
T = seq(0,Tfinal,length.out = M) 
recondingTimesMat = matrix(nrow = N, ncol = M)
yMat = matrix(nrow = N, ncol = M)

for (i in 1:N){
  peak = runif(min = 0.2,max =  0.8,1) * Tfinal 
  recondingTimesMat[i,] = sort( unique(c( seq(0.0 , peak, length.out = round((M+1)/2)),
                            seq( peak, Tfinal, length.out = round((M+1)/2))))) * Tfinal
  yMat[i,] = me(recondingTimesMat[i,]) * rnorm(1, mean=4.0, sd=  eps)
                                       + rnorm(M, mean=0.0, sd=  eps) 
}

Y = as.list(as.data.frame(t(yMat)))
X = rep(list(T),N)
 
sss =  WFDA(Ly = Y, Lt = X, list( choice = 'weighted' ))
par(mfrow=c(1,2))
matplot(x= T, t(yMat), t='l', main = 'Raw', ylab = 'Y'); grid()
matplot(x= T, t(sss$aligned), t='l', main = 'Aligned', ylab='Y'); grid() 
}
\references{
\cite{Tang, R. and Mueller, H.G. (2008). "Pairwise curve synchronization for functional data." Biometrika 95, 875-889}

\cite{Tang, R. and Mueller, H.G. (2009) "Time-synchronized clustering of gene expression trajectories." Biostatistics 10, 32-45}
}

