% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare-caps.R
\name{plot.mcaps}
\alias{plot.mcaps}
\title{Plots results of multiple clustering strategies}
\usage{
\method{plot}{mcaps}(
  x,
  validation_criterion = c("wss", "silhouette"),
  what = c("mean", "distribution"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{mcaps}.}

\item{validation_criterion}{A string specifying the validation criterion to
be used for the comparison. Choices are \code{"wss"} or \code{"silhouette"}. Defaults
to \code{"wss"}.}

\item{what}{A string specifying the kind of information to display about the
validation criterion. Choices are \code{"mean"} (which plots the mean values) or
\code{"distribution"} (which plots the boxplots). Defaults to \code{"mean"}.}

\item{...}{Other arguments passed to specific methods.}
}
\description{
This is an S3 method implementation of the \code{\link[graphics:plot.default]{graphics::plot()}} generic for
objects of class \code{mcaps} to visualize the performances of multiple \code{\link{caps}}
objects applied on the same data sets either in terms of WSS or in terms of
silhouette values.
}
\examples{
plot(sim30_mcaps)
}
