% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.mesh.3D}
\alias{plot.mesh.3D}
\title{Plot a mesh.3D object}
\usage{
\method{plot}{mesh.3D}(x, ...)
}
\arguments{
\item{x}{A \code{mesh.3D} object generated by \code{create.mesh.3D}.}

\item{...}{Arguments representing graphical options to be passed to \link[graphics]{par}.}
}
\description{
Plot a \code{mesh.3D} object, generated by \code{create.mesh.3D}.
}
\examples{
library(fdaPDE)

##Load the matrix nodes and tetrahedrons
data(sphere3Ddata)

nodes = sphere3Ddata$nodes
tetrahedrons = sphere3Ddata$tetrahedrons

##Create the triangulated mesh from the connectivity matrix and nodes locations
mesh = create.mesh.3D(nodes,tetrahedrons)

##Plot the triangulation of the object
plot(mesh)
}
