% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FEMobjects.R
\name{create.FEM.basis}
\alias{create.FEM.basis}
\title{Create a FEM basis}
\usage{
create.FEM.basis(mesh, saveTree = FALSE)
}
\arguments{
\item{mesh}{A \code{mesh.2D}, \code{mesh.2.5D} or \code{mesh.3D} object representing the domain triangulation. See \link{create.mesh.2D}, \link{create.mesh.2.5D}, \link{create.mesh.3D}.}

\item{saveTree}{a flag to decide to save the tree mesh information in advance (default is FALSE)}
}
\value{
A \code{FEMbasis} object. This contains the \code{mesh}, along with some additional quantities:
\describe{
	\item{\code{order}}{Either "1" or "2" for the 2D and 2.5D case, and "1" for the 3D case.
	Order of the Finite Element basis.}
	\item{\code{nbasis}}{Scalar. The number of basis.}
}
}
\description{
Sets up a Finite Element basis. It requires a \code{mesh.2D}, \code{mesh.2.5D} or \code{mesh.3D} object,
as input.
The basis' functions are globally continuos functions, that are polynomials once restricted to a triangle in the mesh.
The current implementation includes linear finite elements (when \code{order = 1} in the input \code{mesh}) and
quadratic finite elements (when \code{order = 2} in the input \code{mesh}).
If saveTree flag is TRUE, it saves the tree mesh information in advance inside mesh object and can be used later on to save mesh construction time.
}
\examples{
library(fdaPDE)
## Upload the quasicircle2D data
data(quasicircle2D)

## Create the 2D mesh
mesh = create.mesh.2D(nodes = rbind(quasicircle2D$boundary_nodes, 
quasicircle2D$locations), segments = quasicircle2D$boundary_segments)
## Plot it
plot(mesh)
## Create the basis
FEMbasis = create.FEM.basis(mesh)
## Upload the hub2.5D data
data(hub2.5D)

hub2.5D.nodes = hub2.5D$hub2.5D.nodes
hub2.5D.triangles = hub2.5D$hub2.5D.triangles
## Create the 2.5D mesh
mesh = create.mesh.2.5D(nodes = hub2.5D.nodes, triangles = hub2.5D.triangles)
## Plot it
plot(mesh)
## Create the basis
FEMbasis = create.FEM.basis(mesh)
}
\seealso{
\code{\link{create.mesh.2D}}, \code{\link{create.mesh.2.5D}},\code{\link{create.mesh.3D}}
}
