% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FEMevaluator.R
\name{eval.FEM.time}
\alias{eval.FEM.time}
\title{Evaluate a FEM.time object at a set of point locations}
\usage{
eval.FEM.time(FEM.time, locations = NULL, time.instants = NULL, 
                     space.time.locations = NULL, incidence_matrix = NULL, lambdaS = 1, 
                     lambdaT = 1, search = "tree", bary.locations = NULL)
}
\arguments{
\item{FEM.time}{A \code{FEM.time} object to be evaluated.}

\item{locations}{A 2-columns (in case of planar mesh) or 3-columns(in case of 2D manifold in a 3D space or a 3D volume) matrix with the spatial locations where the FEM.time object should be evaluated.}

\item{time.instants}{A vector with the time instants where the FEM.time object should be evaluated.}

\item{space.time.locations}{A 3-columns (in case of planar mesh) or 4-columns(in case of 2D manifold in a 3D space or a 3D volume) 
matrix with the time instants and spatial locations where the FEM.time object should be evaluated. 
The first column is for the time instants. If given, \code{locations}, \code{incidence_matrix} and \code{time.instants} must be NULL.}

\item{incidence_matrix}{In case of areal data, the #regions x #elements incidence matrix defining the regions.}

\item{lambdaS}{The index of the lambdaS choosen for the evaluation.}

\item{lambdaT}{The index of the lambdaT choosen for the evaluation.}

\item{search}{a flag to decide the search algorithm type (tree or naive or walking search algorithm).}

\item{bary.locations}{A list with three vectors:
\code{locations}, location points which are same as the given locations options. (checks whether both locations are the same);
\code{element ids}, a vector of element id of the points from the mesh where they are located;
\code{barycenters}, a vector of barycenter of points from the located element.}
}
\value{
A matrix of numeric evaluations of the \code{FEM.time} object. Each row indicates the location where 
the evaluation has been taken, the column indicates the function evaluated.
}
\description{
It evaluates a \code{FEM.time} object at the specified set of locations or regions. 
If \code{space.time.locations} is provided \code{locations}, \code{incidence_matrix} and 
\code{time.instants} must be NULL. Otherwise \code{time.instants} and one of \code{locations} and 
\code{incidence_matrix} must be given. In this case the evaluation is perform on the tensor grid
\code{time.instants}-by-\code{locations} (or \code{time.instants}-by-areal domains).
}
\examples{
library(fdaPDE)
## Upload the horseshoe2D data
data(horseshoe2D)
boundary_nodes = horseshoe2D$boundary_nodes
boundary_segments = horseshoe2D$boundary_segments
locations = horseshoe2D$locations

## Create the 2D mesh
mesh = create.mesh.2D(nodes = rbind(boundary_nodes, locations), segments = boundary_segments)
## Create the FEM basis
FEMbasis = create.FEM.basis(mesh)
## Compute the coeff vector evaluating the desired function at the mesh nodes
## In this case we consider the fs.test() function introduced by Wood et al. 2008
time = 1:5
coeff = rep(fs.test(mesh$nodes[,1], mesh$nodes[,2]),5)*time
## Create the FEM.time object
FEM_time_function = FEM.time(coeff=coeff, time_mesh=1:5, FEMbasis=FEMbasis, FLAG_PARABOLIC=TRUE)

evaluations = eval.FEM.time(FEM_time_function, locations = matrix(c(-0.92,0), ncol=2), 
                            time.instants = time)
}
\references{
Devillers, O. et al. 2001. Walking in a Triangulation, Proceedings of the Seventeenth Annual Symposium on Computational Geometry
}
