% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h.default.R
\name{h.default}
\alias{h.default}
\title{Calculation of the smoothing parameter (h) for a functional data}
\usage{
h.default(
  fdataobj,
  prob = c(0.025, 0.25),
  len = 51,
  metric = metric.lp,
  type.S = "S.NW",
  Ker = Ker.norm,
  ...
)
}
\arguments{
\item{fdataobj}{\code{\link{fdata}} class object.}

\item{prob}{Vector of probabilities for extracting the quantiles of the distance matrix. If \code{length(prob)=2} 
a sequence between \code{prob[1]} and \code{prob[2]} of length \code{len}.}

\item{len}{Vector length of smoothing parameter \code{h} to return only used when \code{length(prob)=2}.}

\item{metric}{If is a function: name of the function to calculate the
distance matrix between the curves, by default \code{\link{metric.lp}}.  If
is a matrix: distance matrix between the curves.
kernel.}

\item{type.S}{Type of smothing matrix \code{S}.  Possible values are:
Nadaraya-Watson estimator \emph{"S.NW"} and K nearest neighbors estimator
\emph{"S.KNN"}}

\item{Ker}{Kernel function. By default, \emph{Ker.norm}. Useful for scaling the bandwidth values
according to Kernel}

\item{\dots}{Arguments to be passed for metric argument.}
}
\value{
Returns the vector of smoothing parameter or bandwidth \code{h}.
}
\description{
Calculation of the smoothing parameter (h) for a functional data using
nonparametric kernel estimation.
}
\examples{
\dontrun{
data(aemet)
h1<-h.default(aemet$temp,prob=c(0.025, 0.25),len=2)
mdist<-metric.lp(aemet$temp)
h2<-h.default(aemet$temp,len=2,metric=mdist)
h3<-h.default(aemet$temp,len=2,metric=semimetric.pca,q=2)
h4<-h.default(aemet$temp,len=2,metric=semimetric.pca,q=4)
h5<-h.default(aemet$temp,prob=c(.2),type.S="S.KNN")
h1;h2;h3;h4;h5
}
}
\seealso{
See Also as \code{\link{metric.lp}}, \code{\link{Kernel}} and
\code{\link{S.NW}}. \cr Function used in \code{\link{fregre.np}} and
\code{\link{fregre.np.cv}} function.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@udc.es}
}
\keyword{nonparametric}
