% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fanova.onefactor.R
\name{fanova.onefactor}
\alias{fanova.onefactor}
\alias{anova.onefactor}
\title{One--way anova model for functional data}
\usage{
fanova.onefactor(
  object,
  group,
  nboot = 100,
  plot = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{functional response data.  fdata class object with \code{n} curves.}

\item{group}{a factor specifying the class for each curve.}

\item{nboot}{number of bootstrap samples.}

\item{plot}{if \code{TRUE}, plot the mean of each factor level and the results of test.}

\item{verbose}{if \code{TRUE}, print intermediate results.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
Returns:
\itemize{
\item  \code{p-value} probability of rejecting the null hypothesis H0 at a significance level
\item  \code{stat}{ statistic value of test.}
\item  \code{wm}{ statistic values of bootstrap resamples.}
}
}
\description{
One--way anova model for k independent samples of functional data. 
The function contrasts the null hypothesis of equality of mean functions 
of functional data based on the an asymptotic version of the anova F--test. 
\deqn{H_0:\, m_1=\ldots=m_k}{H_0: m_1=,\ldots=m_k,}
}
\details{
The function returns the p--value of  test using one--way anova model over \code{nboot} runs.
}
\note{
anova.onefactor deprecated.
}
\examples{
\dontrun{
data(MCO)
grupo<-MCO$classintact
datos<-MCO$intact
res=fanova.onefactor(datos,grupo,nboot=50,plot=TRUE)
grupo <- MCO$classpermea
datos <- MCO$permea
res=fanova.onefactor(datos,grupo,nboot=50,plot=TRUE)
}  
}
\references{
Cuevas, A., Febrero, M., & Fraiman, R. (2004). \emph{An anova test for functional data.} Computational statistics & data analysis, \bold{47}(1), 111-122.
}
\seealso{
See Also as: \code{\link{fanova.RPm}}
}
\author{
Juan A. Cuesta-Albertos, Manuel Febrero-Bande, Manuel Oviedo de la
Fuente\cr \email{manuel.oviedo@udc.es}
}
\keyword{anova}
