% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif.kfold.R
\name{classif.kfold}
\alias{classif.kfold}
\title{Functional Classification usign k-fold CV}
\usage{
classif.kfold(
  formula,
  data,
  classif = "classif.glm",
  par.classif,
  kfold = 10,
  param.kfold = NULL,
  measure = "accuracy",
  cost,
  models = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{formula}{an object of class \code{formula} (or one that can be coerced to that class):
a symbolic description of the model to be fitted. The procedure only considers functional covariates (not implemented for non-functional covariates).}

\item{data}{\code{list}, it contains the variables in the model.}

\item{classif}{character,  name of classification method to be used in fitting the model, see \code{Details} section.}

\item{par.classif}{\code{list} of arguments used in the classification method.}

\item{kfold}{\code{integer}, number of k-fold.}

\item{param.kfold}{\code{list},  arguments related to number of k-folds for each covariate, see \code{Details} section.}

\item{measure}{\code{character}, type of measure of accuracy used, see \code{\link{cat2meas}} function.}

\item{cost}{\code{numeric}, see \code{\link{cat2meas}} function.}

\item{models}{\code{logical}. If \code{TRUE}, return a list of the fitted models used,  (k-fold -1) X (number of parameters)}

\item{verbose}{\code{logical}. If \code{TRUE}, print some internal results.}

\item{\ldots}{Further arguments passed to or from other methods.}
}
\value{
Best fitted model computed by the k-fold CV  using the method indicated 
in the \code{classif} argument and also returns:
 \enumerate{
  \item \code{param.min}, value of parameter (or parameters) selected by k-fold CV. 
  \item \code{params.error}, k-fold CV error for each parameter combination. 
  \item \code{pred.kfold}, predicted response computed by k-fold CV.
  \item \code{model}, if \code{TRUE}, list of models for each parameter combination.
  }
}
\description{
Computes Functional Classification using k-fold cross-validation
}
\details{
Parameters for k-fold cross validation:
\enumerate{
  \item Number of basis elements: 
\itemize{
\item Data-driven basis such as Functional Principal Componetns (PC). No implemented for PLS basis yet.
\item Fixed basis (bspline, fourier, etc.).  
}
  Option used in some classifiers such as \code{\link{classif.glm}}, \code{\link{classif.gsam}}, \code{\link{classif.svm}}, etc.
\item Bandwidth parameter.  Option used in  non-parametric classificiation models such as  \code{\link{classif.np}} and \code{\link{classif.gkam}}.
}
}
\examples{
\dontrun{
data(tecator)    
cutpoint <- 18
tecator$y$class <-factor(ifelse(tecator$y$Fat<cutpoint,0,1))
table(tecator$y$class )
x<-tecator[[1]]
x2<-fdata.deriv(tecator[[1]],2)
data<- list("df"=tecator$y,x=x,x2=x2)
formula<- formula(class~x+x2)

# ex: default excution of classifier (no k-fold CV)
classif="classif.glm";
out.default<-classif.kfold(formula, data, classif = classif)
out.default
out.default$param.min
out.default$params.error
summary(out.default)

# ex: Number of PC basis elements selected by 10-fold CV
# Logistic classifier
kfold = 10
param.kfold <- list("x"=list("pc"=c(1:8)),"x2"=list("pc"=c(1:8)))
out.kfold1 <- classif.kfold(formula, data, classif = classif,
                            kfold = kfold,param.kfold = param.kfold)
out.kfold1$param.min
min(out.kfold1$params.error)
summary(out.kfold1)

# ex: Number of PC basis elements selected by 10-fold CV
# Logistic classifier with inverse weighting
out.kfold2 <- classif.kfold(formula, data, classif = classif,
                            par.classif=list("weights"="inverse"),
                            kfold = kfold,param.kfold = param.kfold)
out.kfold2$param.min
min(out.kfold2$params.error)
summary(out.kfold2)

# ex: Number of fourier  basis elements selected by 10-fold CV
# Logistic classifier 
ibase = seq(5,15,by=2)
param.kfold <- list("x"=list("fourier"=ibase),
                    "x2"=list("fourier"=ibase))
out.kfold3 <- classif.kfold(formula, data, classif = classif,
                            kfold = kfold,param.kfold = param.kfold)
out.kfold3$param.min
min(out.kfold3$params.error)
summary(out.kfold3)

# ex: Number of k-nearest neighbors selected by 10-fold CV
# non-parametric classifier  (only for a functional covariate)

output<-classif.kfold( class ~ x, data, classif = "classif.knn",
                       param.kfold= list("x"=list("knn"=c(1,3,5,9))))
output$param.min
output$params.error

output<-classif.kfold( class ~ x2, data, classif = "classif.knn",
                       param.kfold= list("x2"=list("knn"=c(1,3,5,9))))
output$param.min
output$params.error 
}
 
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente \email{manuel.oviedo@usc.es}
}
\keyword{classif}
