% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{aemet}
\alias{aemet}
\title{aemet data}
\format{Elements of aemet:\cr \code{..$df:} Data frame with information of
each wheather station:
\itemize{
\item \code{ind:} Indicated weather station.
\item  \code{name:} Station Name.  36 marked UTF-8 strings.
\item  \code{province:}Province (region) of Spain. 36 marked UTF-8 strings
\item \code{altitude:} Altitude of the station (in meters).
\item   \code{year.ini:} Start year.
\item  \code{year.end:} End year.
\item  \code{longitude:} x geographic coordinate of the station (in decimal degrees).
\item  \code{latitude:} y geographic coordinate of the station (in decimal degrees).
}
The functional variables: 
\itemize{
\item  \code{...$temp}: mean curve of the average daily temperature
for the period 1980-2009 (in degrees Celsius, marked with UTF-8 string).
In leap years temperatures for February 28 and 29 were averaged.
\item \code{...$wind.speed}: mean curve of the average daily wind speed for the
period 1980-2009 (in m/s).
\item  \code{...$logprec}: mean curve of the log precipitation for
the period 1980-2009 (in log mm). Negligible precipitation 
(less than 1 tenth of mm) is replaced by \code{0.05} and no precipitation
(0.0 mm) is replaced by \code{0.01}.  Then the logarithm is applied.
}}
\source{
The data were obtained from the FTP of AEMET in 2009.
}
\description{
Series of daily summaries of 73 spanish weather stations selected for the
period 1980-2009.  The dataset contains geographic information of each
station and the average for the period 1980-2009 of daily temperature, daily
precipitation and daily wind speed.
}
\details{
Meteorological State Agency of Spain (AEMET), \url{http://www.aemet.es/}. Government of Spain.\cr
It marks 36 UTF-8 string of names of stations and 3 UTF-8 string names of provinces through the function \code{\link{iconv}}.\cr
}
\examples{
\dontrun{
data(aemet)
names(aemet)
names(aemet$df)
par(mfrow=c(3,1))
plot(aemet$temp)
plot(aemet$wind.speed)
plot(aemet$logprec)
}
}
\author{
Manuel Febrero Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
\keyword{datasets}
