% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fregre.basis.fr.r
\name{fregre.basis.fr}
\alias{fregre.basis.fr}
\title{Functional Regression with functional response using basis representation.}
\usage{
fregre.basis.fr(x, y, basis.s = NULL, basis.t = NULL, lambda.s = 0,
  lambda.t = 0, Lfdobj.s = vec2Lfd(c(0, 0), range.s),
  Lfdobj.t = vec2Lfd(c(0, 0), range.t), weights = NULL, ...)
}
\arguments{
\item{x}{Functional explanatory variable.}

\item{y}{Functional response variable.}

\item{basis.s}{Basis related with \code{s} and it is used in the estimation
of \eqn{\beta(s,t)}.}

\item{basis.t}{Basis related with \code{t} and it is used in the estimation
of \eqn{\beta(s,t)}.}

\item{lambda.s}{A roughness penalty with respect to \code{s} to be applied
in the estimation of \eqn{\beta(s,t)}. By default, no penalty
\code{lambda.s=0}.}

\item{lambda.t}{A roughness penalty with respect to \code{t} to be applied
in the estimation of \eqn{\beta(s,t)}.  By default, no penalty
\code{lambda.t=0}.}

\item{Lfdobj.s}{A linear differential operator object with respect to
\code{s} . See \link[fda]{eval.penalty}.}

\item{Lfdobj.t}{A linear differential operator object with respect to
\code{t}. See \link[fda]{eval.penalty}.}

\item{weights}{Weights.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Return:
\itemize{
\item \code{call}{ The matched call.} 
\item \code{a.est}{ Intercept parameter estimated.} 
\item \code{coefficientes}{ the matrix of the coefficients.}
\item \code{beta.est}{ A bivariate functional data object of class \code{bifd} with the estimated parameters of \eqn{\beta(s,t)}{\beta(s,t)}.}
\item \code{fitted.values}{ Estimated response.} 
\item \code{residuals}{ \code{y} minus \code{fitted values}.} 
\item \code{y}{ Functional response.} 
\item \code{x}{ Functional explanatory data.} 
\item \code{lambda.s}{ A roughness penalty with respect to \code{s} .} 
\item \code{lambda.t}{ A roughness penalty with respect to \code{t}.}
\item \code{Lfdobj.s}{ A linear differential operator with respect to \code{s}.}
\item \code{Lfdobj.t}{ A linear differential operator with respect to \code{t}.}
\item \code{weights}{ Weights.} 
}
}
\description{
Computes functional regression between functional explanatory variable
\eqn{X(s)} and functional response \eqn{Y(t)} using basis representation.
}
\details{
\deqn{Y(t)=\alpha(t)+\int_{T}{X(s)\beta(s,t)ds+\epsilon(t)}}{Y=\alpha(t)+\int
X(s)\beta(s,t)ds+\epsilon(t)}

where \eqn{\alpha(t)} is the intercept function, \eqn{\beta(s,t)} is the
bivariate resgression function and \eqn{\epsilon(t)} are the error term with
mean zero.
 
The function is a wrapped of \code{\link{linmod}} function proposed by
Ramsay and Silverman (2005) to model the relationship between the functional
response \eqn{Y(t)} and the functional covariate \eqn{X(t)} by basis
representation of both.

The unknown bivariate functional parameter \eqn{\beta(s,t)}{\beta(s,t)} can
be expressed as a double expansion in terms of \eqn{K} basis function
\eqn{\nu_k} and \eqn{L} basis functions \eqn{\theta_l},
\deqn{\beta(s,t)=\sum_{k=1}^{K}\sum_{l=1}^{L} b_{kl}
\nu_{k}(s)\theta_{l}(t)=\nu(s)^{\top}\bold{B}\theta(t)}{\beta(s,t)=\sum_k
\sum_l b_{kl} \nu_k(s)\theta_l(t)=\nu(s)'B\theta(t)} Then, the model can be
re--written in a matrix version as,
\deqn{Y(t)=\alpha(t)+\int_{T}{X(s)\nu(s)^{\top}\bold{B}\theta(t)ds+\epsilon(t)}=\alpha(t)+\bold{XB}\theta(t)+\epsilon(t)}{Y(t)=\alpha(t)+\int
X(s)\nu(s)'B\theta(t)ds+\epsilon(t)=\alpha(t)+XB\theta(t)+\epsilon(t)} where
\eqn{\bold{X}=\int X(s)\nu^{\top}(t)ds}{X=\int X(s)\nu'(t)ds} \cr

This function allows objects of class \code{fdata} or directly covariates of
class \code{fd}.  If \code{x} is a \code{fdata} class, \code{basis.s} is
also the basis used to represent \code{x} as \code{fd} class object. If
\code{y} is a \code{fdata} class, \code{basis.t} is also the basis used to
represent \code{y} as \code{fd} class object. The function also gives
default values to arguments \code{basis.s} and \code{basis.t} for construct
the bifd class object used in the estimation of \eqn{\beta(s,t)}.  If
\code{basis.s=}\code{NULL} or \code{basis.t=}\code{NULL} the function
creates a \code{bspline} basis by \code{\link{create.bspline.basis}}.

\code{fregre.basis.fr} incorporates a roughness penalty using an appropiate
linear differential operator; {\code{lambda.s},\code{Lfdobj.s}} for
penalization of \eqn{\beta}{\beta}'s variations with respect to \eqn{s} and
\cr {\code{lambda.t},\code{Lfdobj.t}} for penalization of
\eqn{\beta}{\beta}'s variations with respect to \eqn{t}.\cr
}
\examples{
\dontrun{
rtt<-c(0, 365)
basis.alpha  <- create.constant.basis(rtt)
basisx  <- create.bspline.basis(rtt,11)
basisy  <- create.bspline.basis(rtt,11)
basiss  <- create.bspline.basis(rtt,7)
basist  <- create.bspline.basis(rtt,9)

# fd class
dayfd<-Data2fd(day.5,CanadianWeather$dailyAv,basisx)
tempfd<-dayfd[,1]
log10precfd<-dayfd[,3]
res1 <-  fregre.basis.fr(tempfd, log10precfd,
basis.s=basiss,basis.t=basist)

# fdata class
tt<-1:365
tempfdata<-fdata(t(CanadianWeather$dailyAv[,,1]),tt,rtt)
log10precfdata<-fdata(t(CanadianWeather$dailyAv[,,3]),tt,rtt)
res2<-fregre.basis.fr(tempfdata,log10precfdata,
basis.s=basiss,basis.t=basist)

# penalization
Lfdobjt <- Lfdobjs <- vec2Lfd(c(0,0), rtt)
Lfdobjt <- vec2Lfd(c(0,0), rtt)
lambdat<-lambdas <- 100
res1.pen <- fregre.basis.fr(tempfdata,log10precfdata,basis.s=basiss,
basis.t=basist,lambda.s=lambdas,lambda.t=lambdat,
Lfdobj.s=Lfdobjs,Lfdobj.t=Lfdobjt)

res2.pen <- fregre.basis.fr(tempfd, log10precfd,
basis.s=basiss,basis.t=basist,lambda.s=lambdas,
lambda.t=lambdat,Lfdobj.s=Lfdobjs,Lfdobj.t=Lfdobjt)

plot(log10precfd,col=1)
lines(res1$fitted.values,col=2)
plot(res1$residuals)
plot(res1$beta.est,tt,tt)
plot(res1$beta.est,tt,tt,type="persp",theta=45,phi=30)
}
}
\references{
Ramsay, James O., and Silverman, Bernard W. (2006), \emph{
Functional Data Analysis}, 2nd ed., Springer, New York.
}
\seealso{
See Also as: \code{\link{predict.fregre.fr}}.
Alternative method: \code{\link{linmod}}.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
\keyword{regression}
