% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{r.ou}
\alias{r.ou}
\title{Ornstein-Uhlenbeck process}
\usage{
r.ou(n, t = seq(0, 1, len = 201), mu = 0, alpha = 1, sigma = 1,
  x0 = rnorm(n, mean = mu, sd = sigma/sqrt(2 * alpha)))
}
\arguments{
\item{n}{number of functions to sample.}

\item{t}{time locations for the functional data.}

\item{mu}{mean of the process.}

\item{alpha}{strength of the drift.}

\item{sigma}{diffusion coefficient.}

\item{x0}{a number or a vector of length \code{n} giving the initial value(s) of the Ornstein-Uhlenbeck process. By default, \code{n} points are sampled from the stationary distribution.}
}
\value{
Functional sample, an \code{\link[fda.usc]{fdata}} object of length \code{n}.
}
\description{
Sampling of paths of the Ornstein-Uhlenbeck process.
}
\examples{
plot(r.ou(n = 100))
plot(r.ou(n = 100, alpha = 2, sigma = 4, x0 = 1:100))
}
\author{
Eduardo Garcia-Portugues (\email{edgarcia@est-econ.uc3m.es}).
}

