% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concept_lattice.R
\name{ConceptLattice}
\alias{ConceptLattice}
\title{R6 class for a context lattice}
\description{
This class implements the data structure and methods for concept lattices.
}
\examples{
# Build a formal context
fc_planets <- FormalContext$new(planets)

# Find the concepts
fc_planets$find_concepts()

# Plot the concept lattice
fc_planets$concepts$plot()

# Find join- and meet- irreducible elements
fc_planets$concepts$join_irreducibles()
fc_planets$concepts$meet_irreducibles()

# Get concept support
fc_planets$concepts$support()

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ConceptLattice$new()}}
\item \href{#method-size}{\code{ConceptLattice$size()}}
\item \href{#method-is_empty}{\code{ConceptLattice$is_empty()}}
\item \href{#method-extents}{\code{ConceptLattice$extents()}}
\item \href{#method-intents}{\code{ConceptLattice$intents()}}
\item \href{#method-plot}{\code{ConceptLattice$plot()}}
\item \href{#method-print}{\code{ConceptLattice$print()}}
\item \href{#method-to_latex}{\code{ConceptLattice$to_latex()}}
\item \href{#method-[}{\code{ConceptLattice$[()}}
\item \href{#method-sublattice}{\code{ConceptLattice$sublattice()}}
\item \href{#method-join_irreducibles}{\code{ConceptLattice$join_irreducibles()}}
\item \href{#method-meet_irreducibles}{\code{ConceptLattice$meet_irreducibles()}}
\item \href{#method-decompose}{\code{ConceptLattice$decompose()}}
\item \href{#method-supremum}{\code{ConceptLattice$supremum()}}
\item \href{#method-infimum}{\code{ConceptLattice$infimum()}}
\item \href{#method-subconcepts}{\code{ConceptLattice$subconcepts()}}
\item \href{#method-superconcepts}{\code{ConceptLattice$superconcepts()}}
\item \href{#method-lower_neighbours}{\code{ConceptLattice$lower_neighbours()}}
\item \href{#method-upper_neighbours}{\code{ConceptLattice$upper_neighbours()}}
\item \href{#method-support}{\code{ConceptLattice$support()}}
\item \href{#method-clone}{\code{ConceptLattice$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{ConceptLattice} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$new(extents, intents, objects, attributes, I = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extents}}{(\code{dgCMatrix}) The extents of all concepts}

\item{\code{intents}}{(\code{dgCMatrix}) The intents of all concepts}

\item{\code{objects}}{(character vector) Names of the objects in the formal context}

\item{\code{attributes}}{(character vector) Names of the attributes in the formal context}

\item{\code{I}}{(\code{dgCMatrix}) The matrix of the formal context}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ConceptLattice} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-size"></a>}}
\if{latex}{\out{\hypertarget{method-size}{}}}
\subsection{Method \code{size()}}{
Size of the Lattice
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The number of concepts in the lattice.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_empty"></a>}}
\if{latex}{\out{\hypertarget{method-is_empty}{}}}
\subsection{Method \code{is_empty()}}{
Is the lattice empty?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$is_empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if the lattice has no concepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-extents"></a>}}
\if{latex}{\out{\hypertarget{method-extents}{}}}
\subsection{Method \code{extents()}}{
Concept Extents
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$extents()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The extents of all concepts, as a \code{dgCMatrix}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intents"></a>}}
\if{latex}{\out{\hypertarget{method-intents}{}}}
\subsection{Method \code{intents()}}{
Concept Intents
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$intents()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The intents of all concepts, as a \code{dgCMatrix}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the concept lattice
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$plot(object_names = TRUE, to_latex = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{object_names}}{(logical) If \code{TRUE}, plot object names, otherwise omit them from the diagram.}

\item{\code{to_latex}}{(logical) If \code{TRUE}, export the plot as a \code{tikzpicture} environment that can be included in a \code{LaTeX} file.}

\item{\code{...}}{Other parameters to be passed to the \code{tikzDevice} that renders the lattice in \code{LaTeX}, or for the figure caption. See \code{Details}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Particular parameters that control the size of the \code{tikz} output are: \code{width}, \code{height} (both in inches), and \code{pointsize} (in points), that should be set to the font size used in the \code{documentclass} header in the \code{LaTeX} file where the code is to be inserted.

If a \code{caption} is provided, the whole \code{tikz} picture will be wrapped by a \code{figure} environment and the caption set.
}

\subsection{Returns}{
If \code{to_latex} is \code{FALSE}, it returns nothing, just plots the graph of the concept lattice. Otherwise, this function returns the \code{LaTeX} code to reproduce the concept lattice.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the Concept Lattice
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing, just prints the lattice.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_latex"></a>}}
\if{latex}{\out{\hypertarget{method-to_latex}{}}}
\subsection{Method \code{to_latex()}}{
Write in LaTeX
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$to_latex(print = TRUE, ncols = 1, numbered = TRUE, align = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{print}}{(logical) Print to output?}

\item{\code{ncols}}{(integer) Number of columns of the output.}

\item{\code{numbered}}{(logical) Number the concepts?}

\item{\code{align}}{(logical) Align objects and attributes independently?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{LaTeX} code to list all concepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-["></a>}}
\if{latex}{\out{\hypertarget{method-[}{}}}
\subsection{Method \code{[()}}{
Get Concepts by Index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$[(indices)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{indices}}{(numeric or logical vector) The indices of the concepts to return as a list of SparseConcepts. It can be a vector of logicals where \code{TRUE} elements are to be retained.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of SparseConcepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sublattice"></a>}}
\if{latex}{\out{\hypertarget{method-sublattice}{}}}
\subsection{Method \code{sublattice()}}{
Sublattice
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$sublattice(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See Details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
As argument, one can provide both integer indices or \code{SparseConcepts}, separated by commas. The corresponding concepts are used to generate a sublattice.
}

\subsection{Returns}{
The generated sublattice as a new \code{ConceptLattice} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-join_irreducibles"></a>}}
\if{latex}{\out{\hypertarget{method-join_irreducibles}{}}}
\subsection{Method \code{join_irreducibles()}}{
Join-irreducible Elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$join_irreducibles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The join-irreducible elements in the concept lattice.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-meet_irreducibles"></a>}}
\if{latex}{\out{\hypertarget{method-meet_irreducibles}{}}}
\subsection{Method \code{meet_irreducibles()}}{
Meet-irreducible Elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$meet_irreducibles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The meet-irreducible elements in the concept lattice.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-decompose"></a>}}
\if{latex}{\out{\hypertarget{method-decompose}{}}}
\subsection{Method \code{decompose()}}{
Decompose a concept as the supremum of meet-irreducible concepts
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$decompose(C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{C}}{A list of \code{SparseConcept}s}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list, each field is the set of meet-irreducible elements whose supremum is the corresponding element in \code{C}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-supremum"></a>}}
\if{latex}{\out{\hypertarget{method-supremum}{}}}
\subsection{Method \code{supremum()}}{
Supremum of Concepts
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$supremum(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See Details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
As argument, one can provide both integer indices or \code{SparseConcepts}, separated by commas. The corresponding concepts are used to compute their supremum in the lattice.
}

\subsection{Returns}{
The supremum of the list of concepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-infimum"></a>}}
\if{latex}{\out{\hypertarget{method-infimum}{}}}
\subsection{Method \code{infimum()}}{
Infimum of Concepts
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$infimum(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See Details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
As argument, one can provide both integer indices or \code{SparseConcepts}, separated by commas. The corresponding concepts are used to compute their infimum in the lattice.
}

\subsection{Returns}{
The infimum of the list of concepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-subconcepts"></a>}}
\if{latex}{\out{\hypertarget{method-subconcepts}{}}}
\subsection{Method \code{subconcepts()}}{
Subconcepts of a Concept
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$subconcepts(C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{C}}{(numeric or \code{SparseConcept}) The concept to which determine all its subconcepts.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the subconcepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-superconcepts"></a>}}
\if{latex}{\out{\hypertarget{method-superconcepts}{}}}
\subsection{Method \code{superconcepts()}}{
Superconcepts of a Concept
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$superconcepts(C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{C}}{(numeric or \code{SparseConcept}) The concept to which determine all its superconcepts.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the superconcepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-lower_neighbours"></a>}}
\if{latex}{\out{\hypertarget{method-lower_neighbours}{}}}
\subsection{Method \code{lower_neighbours()}}{
Lower Neighbours of a Concept
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$lower_neighbours(C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{C}}{(\code{SparseConcept}) The concept to which find its lower neighbours}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the lower neighbours of \code{C}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-upper_neighbours"></a>}}
\if{latex}{\out{\hypertarget{method-upper_neighbours}{}}}
\subsection{Method \code{upper_neighbours()}}{
Upper Neighbours of a Concept
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$upper_neighbours(C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{C}}{(\code{SparseConcept}) The concept to which find its upper neighbours}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the upper neighbours of \code{C}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-support"></a>}}
\if{latex}{\out{\hypertarget{method-support}{}}}
\subsection{Method \code{support()}}{
Get support of each concept
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$support()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector with the support of each concept.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
