% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbroc.paired.methods.R
\name{plot.fbroc.paired.roc}
\alias{plot.fbroc.paired.roc}
\title{Plots a \code{fbroc.paired.roc} object}
\usage{
\method{plot}{fbroc.paired.roc}(x, col1 = "blue", fill1 = "dodgerblue",
  col2 = "darkgreen", fill2 = "seagreen1", print.plot = TRUE,
  show.conf = TRUE, conf.level = 0.95, steps = 250, show.metric = NULL,
  show.area = !show.conf, text.size.perf = 6, ...)
}
\arguments{
\item{x}{An object of class  \code{fbroc.paired.roc}.}

\item{col1}{Color in which the ROC curve of the first classifier is drawn.}

\item{fill1}{Color used for areas (confidence regions, AUCs and partial AUCs) belonging
to the first ROC curve.}

\item{col2}{Color in which the ROC curve of the second classifier is drawn.}

\item{fill2}{Color used for areas (confidence regions, AUCs and partial AUCs) belonging
to the second ROC curve.}

\item{print.plot}{Logical specifying whether the plot should be printed.}

\item{show.conf}{Logical specifying whether the confidence region should be
plotted.}

\item{conf.level}{Confidence level of the confidence region.}

\item{steps}{Number of discrete steps for the FPR at which the TPR is 
calculated. TPR confidence intervals are given for all FPRs in 
\code{seq(0, 1, by = (1 / steps))}. Defaults to 250.}

\item{show.metric}{Character specifying which metric to display. See 
\code{\link{perf.fbroc.roc}} for details. Defaults to \code{NULL}, which means
that no metric is displayed.}

\item{show.area}{Whether to shade the AUC or partial AUC area. Defaults to !show.conf.}

\item{text.size.perf}{Size of the text display when show.metric is set to \code{TRUE}.
Defaults to 6.}

\item{...}{further arguments passed to \code{\link{perf.fbroc.paired.roc}}.}
}
\value{
A ggplot, so that the user can customize the plot further.
}
\description{
Plots a \code{fbroc.paired.roc} object and shows the two paired ROC curves. The confidence
regions for the ROC curves and the performance estimates and confidence bounds for a specified metric 
can also be included in the plot.
}
\examples{
data(roc.examples)
example <- boot.paired.roc(roc.examples$Cont.Pred, roc.examples$Cont.Pred.Outlier,
                           roc.examples$True.Class, n.boot = 100)
plot(example) # standard plot, no metric shown
plot(example, show.metric = "auc") # Include information about the AUC
plot(example, show.metric = "auc", show.conf = FALSE) # Show area instead
# Highlight TPR at an FPR of 20\% 
plot(example, show.metric = "tpr", fpr = 0.2)    
plot(example, show.metric = "partial.auc", fpr = c(0.2, 0.4), 
     show.conf = FALSE, show.partial.auc.warning = FALSE) # Show area                  
}
\seealso{
\code{\link{boot.paired.roc}}
}

