% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markerSimfb.R
\name{markerSimfb}
\alias{markerSimfb}
\title{Marker simulation}
\usage{
markerSimfb(
  x,
  N = 1,
  available = NULL,
  alleles = NULL,
  afreq = NULL,
  partialmarker = NULL,
  loop_breakers = NULL,
  eliminate = 0,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{a \code{linkdat} object}

\item{N}{a positive integer: the number of markers to be simulated}

\item{available}{a vector containing IDs of the available individuals, i.e.
those whose genotypes should be simulated. By default, all individuals are
included.}

\item{alleles}{a vector containing the alleles for the marker to be
simulation. If a single integer is given, this is interpreted as the number
of alleles, and the actual alleles as \code{1:alleles}. Must be NULL if
\code{partialmarker} is non-NULL.}

\item{afreq}{a vector of length 2 containing the population frequencies for
the marker alleles. Must be NULL if \code{partialmarker} is non-NULL.}

\item{partialmarker}{Either NULL (resulting in unconditional simulation), a
marker object (on which the simulation should be conditioned) or the index
of an existing marker of \code{x}.}

\item{loop_breakers}{a numeric containing IDs of individuals to be used as
loop breakers. Relevant only if the pedigree has loops, and only if
\code{partialmarker} is non-NULL. See \code{breakLoopsfb}.}

\item{eliminate}{A non-negative integer, indicating the number of iterations
in the internal genotype-compatibility algorithm. Positive values can save
time if \code{partialmarker} is non-NULL and the number of alleles is
large.}

\item{seed}{NULL, or a numeric seed for the random number generator.}

\item{verbose}{a logical.}
}
\value{
a \code{linkdat} object equal to \code{x} except its
\code{markerdata} entry, which consists of the \code{N} simulated markers.
}
\description{
Simulates marker genotypes conditional on the pedigree structure, affection
statuses and disease model.
}
\details{
This implements (with various time savers) the algorithm used in SLINK of the
LINKAGE/FASTLINK suite. If \code{partialmarker} is NULL, genotypes are
simulated by simple gene dropping, using \code{simpleSim}.
}
\references{
G. M. Lathrop, J.-M. Lalouel, C. Julier, and J. Ott,
\emph{Strategies for Multilocus Analysis in Humans}, PNAS 81(1984), pp.
3443-3446.
}
\seealso{
\code{simpleSim}, \code{linkage.power}
}
