% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkdat.R
\name{linkdat}
\alias{linkdat}
\alias{singletonfb}
\alias{print.linkdat}
\alias{summary.linkdat}
\alias{subset.linkdat}
\title{Linkdat objects}
\usage{
linkdat(
  ped,
  model = NULL,
  map = NULL,
  dat = NULL,
  freq = NULL,
  annotations = NULL,
  missing = 0,
  header = FALSE,
  checkped = TRUE,
  verbose = TRUE,
  ...
)

singletonfb(id, sex = 1, famid = 1, verbose = FALSE, ...)

\method{print}{linkdat}(x, ..., markers)

\method{summary}{linkdat}(object, ...)

\method{subset}{linkdat}(x, subset = x$orig.ids, ..., markers = seq_len(x$nMark))
}
\arguments{
\item{ped}{a matrix, data.frame or a character with the path to a pedigree
file in standard LINKAGE format. (See details)}

\item{model}{either a \code{linkdat.model} object (typically \code{y$model}
for some linkdat object \code{y}), or a single integer with the following
meaning: 1 = autosomal dominant; 2 = autosomal recessive; 3 = X-linked
dominant; 4 = X-linked recessive. In each of these cases, the disease is
assumed fully penetrant and the disease allele frequency is set to 0.00001.
If \code{model=NULL}, no model is set.}

\item{map}{a character with the path to a map file in MERLIN format, or NULL.
If non-NULL, a dat file must also be given (next item).}

\item{dat}{a character with the path to a dat file in MERLIN format, or NULL.
(Only needed if \code{map} is non-NULL.)}

\item{freq}{a character with the path to a allele frequency file in MERLIN
(short) format, or NULL. If NULL, all markers are interpreted as
equifrequent.}

\item{annotations}{a list (of the same length and in the same order as the
marker columns in \code{x}) of marker annotations. If this is non-NULL,
then all of \code{map, dat, freq} should be NULL.}

\item{missing}{the character (of length 1) used for missing alleles. Defaults
to '0'.}

\item{header}{a logical, relevant only if \code{ped} points to a ped file: If
TRUE, the first line of the ped file is skipped.}

\item{checkped}{a logical. If FALSE, no checks for pedigree errors are
performed.}

\item{verbose}{a logical: verbose output or not.}

\item{\dots}{further arguments.}

\item{id, sex}{single numerics describing the individual ID and gender of the
singletonfb.}

\item{famid}{a numeric: the family ID of the singletonfb.}

\item{x, object}{a \code{linkdat} object.}

\item{markers}{a numeric indicating which markers should be included/printed.}

\item{subset}{a numeric containing the individuals in the sub-pedigree to be
extracted. NB: No pedigree checking is done here, so make sure the subset
form a meaningful, closed pedigree.}
}
\value{
A \code{linkdat} object, or a list of \code{linkdat} objects. A
linkdat object is essentially a list with the following entries, some of
which can be NULL.  \item{pedigree }{\code{data.frame} with 5 columns (ID,
FID, MID, SEX, AFF) describing the pedigree in linkage format. (NB:
Internal labeling used.)} \item{orig.ids}{the original individual id
labels.} \item{nInd}{the number of individuals in the pedigree.}
\item{founders}{vector of the founder individuals. (NB: Internal labeling
used.)} \item{nonfounders}{vector of the nonfounder individuals (NB:
Internal labeling used.)} \item{hasLoops}{a logical: TRUE if the pedigree
is inbred.} \item{subnucs}{list containing all (maximal) nuclear families
in the pedigree. Each nuclear family is given as a vector of the form
c(pivot, father, mother, child1, ...), where the pivot is either the id of
the individual linking the nuclear family to the rest of the pedigree, or 0
if there are none. (NB: Internal labeling used.)} \item{markerdata}{a list
of \code{marker} objects.} \item{nMark}{the number of markers.}
\item{available}{a numeric vector containing IDs of available individuals.
Used for simulations and plots.} \item{model}{a \code{linkdat.model}
object, essentially a list containing the model parameters. See
\code{setModel} for details.} \item{loop_breakers}{a matrix with
original loop breaker ID's in the first column and their duplicates in the
second column. This is set by \code{breakLoopsfb}.}
}
\description{
This function has been obtained from paramlink package, no longer maintained.
Functions to create and display 'linkdat' objects.
}
\details{
The file (or matrix or data.frame) \code{ped} must describe one or several
pedigrees in standard LINKAGE format, i.e. with the following columns in
correct order:

1 Family id (optional) (FAMID)

2 Individual id (ID),

3 Father id (FID),

4 Mother id (MID),

5 Gender (SEX): 1 = male, 2 = female,

6 Affection status (AFF): 1 = unaffected, 2 = affected, 0 = unknown,

7 First allele of first marker,

8 Second allele of first marker,

9 First allele of second marker,

a.s.o.

Only columns 2-6 are mandatory. The first column is automatically interpreted
as family id if it has repeated elements.

Internally the individuals are relabelfbed as 1,2,..., but this should rarely
be of concern to the end user. Some pedigree checking is done, but it is
recommended to plot the pedigree before doing any analysis.

Details on the formats of map, dat and frequency files can be found in the
online MERLIN tutorial: \url{http://csg.sph.umich.edu/abecasis/Merlin/}

A singletonfb is a special \code{linkdat} object whose pedigree contains 1
individual. The class attribute of a singletonfb is \code{c('singletonfb',
'linkdat')}
}
\seealso{
\code{pedCreate}, \code{pedModify},
\code{pedParts}, \code{setModel}
}
