% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faviconPlease.R
\name{faviconPlease}
\alias{faviconPlease}
\title{Find the URL to a website's favicon}
\usage{
faviconPlease(
  links,
  functions = list(faviconLink, faviconIco),
  fallback = faviconDuckDuckGo
)
}
\arguments{
\item{links}{Character vector of URLs}

\item{functions}{List of functions for finding URL to a website's favicon.
They are tried in order until a URL is found. If no URL is found, the
fallback is applied.}

\item{fallback}{Either a function or a single character vector. It is
applied when none of the supplied functions are able to find a favicon.}
}
\value{
Character vector with URLs to the favicons for the websites specified
  in the input argument \code{links}. The URLs are generated from one of the
  favicon functions specified in the input argument \code{functions}. If a
  favicon URL cannot be identified, then the returned URL is generated by the
  input argument \code{fallback}.
}
\description{
\code{faviconPlease()} first applies the favicon functions specified in the
argument \code{functions}. If these do not find a favicon URL, then it
applies the fallback function specified by the argument \code{fallback}.
}
\seealso{
\code{\link{faviconLink}},
         \code{\link{faviconIco}},
         \code{\link{faviconDuckDuckGo}},
         \code{\link{faviconGoogle}}
}
