% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts.R
\name{contr_code_treatment}
\alias{contr_code_treatment}
\title{Treatment code a factor}
\usage{
contr_code_treatment(fct, levels = NULL, base = 1)
}
\arguments{
\item{fct}{the factor to contrast code (or a vector)}

\item{levels}{the levels of the factor in order}

\item{base}{the index of the level to use as baseline}
}
\value{
the factor with contrasts set
}
\description{
Treatment coding sets the mean of the reference level (base) as the intercept. 
Each contrast compares one level with the reference level.
}
\examples{
df <- sim_design(between = list(pet = c("cat", "dog")), 
                 mu = c(10, 20), plot = FALSE)
df$pet <- contr_code_treatment(df$pet)
lm(y ~ pet, df) \%>\% broom::tidy()

df <- sim_design(between = list(pet = c("cat", "dog", "ferret")), 
                 mu = c(2, 4, 9), empirical = TRUE, plot = FALSE)
                 
df$pet <- contr_code_treatment(df$pet)
lm(y ~ pet, df) \%>\% broom::tidy()

df$pet <- contr_code_treatment(df$pet, base = 2)
lm(y ~ pet, df) \%>\% broom::tidy()

df$pet <- contr_code_treatment(df$pet, base = "ferret")
lm(y ~ pet, df) \%>\% broom::tidy()
}
