% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastexplain.R
\name{fastexplain}
\alias{fastexplain}
\title{Explain a fastml model using various techniques}
\usage{
fastexplain(
  object,
  method = "dalex",
  features = NULL,
  observation = NULL,
  grid_size = 20,
  shap_sample = 5,
  vi_iterations = 10,
  seed = 123,
  loss_function = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{fastml} object.}

\item{method}{Character string specifying the explanation method.
Supported values are \code{"dalex"}, \code{"lime"}, \code{"ice"},
\code{"ale"}, \code{"surrogate"}, \code{"interaction"}, and
\code{"counterfactual"}. Defaults to \code{"dalex"}.}

\item{features}{Character vector of feature names for partial dependence (model profiles). Default NULL.}

\item{observation}{A single observation for counterfactual explanations. Default NULL.}

\item{grid_size}{Number of grid points for partial dependence. Default 20.}

\item{shap_sample}{Integer number of observations from processed training data to compute SHAP values for. Default 5.}

\item{vi_iterations}{Integer. Number of permutations for variable importance (B). Default 10.}

\item{seed}{Integer. A value specifying the random seed.}

\item{loss_function}{Function. The loss function for \code{model_parts}.
\itemize{
  \item If \code{NULL} and task = 'classification', defaults to \code{DALEX::loss_cross_entropy}.
  \item If \code{NULL} and task = 'regression', defaults to \code{DALEX::loss_root_mean_square}.
}}

\item{...}{Additional arguments passed to the underlying helper functions.}
}
\value{
Prints DALEX explanations: variable importance table & plot, model profiles (if any), and SHAP table & summary plot.
}
\description{
Provides model explainability. When `method = "dalex"` this function:
\itemize{
  \item Creates a DALEX explainer.
  \item Computes permutation-based variable importance with boxplots showing variability, displays the table and plot.
  \item Computes partial dependence-like model profiles if `features` are provided.
  \item Computes Shapley values (SHAP) for a sample of the training observations, displays the SHAP table,
  and plots a summary bar chart of \eqn{\text{mean}(\vert \text{SHAP value} \vert)} per feature. For classification, it shows separate bars for each class.
}
}
\details{
\enumerate{
   \item \bold{Custom number of permutations for VI (vi_iterations):}

   You can now specify how many permutations (B) to use for permutation-based variable importance.
   More permutations yield more stable estimates but take longer.

   \item \bold{Better error messages and checks:}

   Improved checks and messages if certain packages or conditions are not met.

   \item \bold{Loss Function:}

   A \code{loss_function} argument has been added to let you pick a different performance measure (e.g., \code{loss_cross_entropy} for classification, \code{loss_root_mean_square} for regression).

   \item \bold{Parallelization Suggestion:}

 }
}
