% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counterfactual_explain.R
\name{counterfactual_explain}
\alias{counterfactual_explain}
\title{Generate counterfactual explanations for a fastml model}
\usage{
counterfactual_explain(object, observation, ...)
}
\arguments{
\item{object}{A `fastml` object.}

\item{observation}{A single observation (data frame with one row) to compute
counterfactuals for.}

\item{...}{Additional arguments passed to `ceterisParibus::calculate_counterfactuals`.}
}
\value{
A counterfactual explanation object.
}
\description{
Uses the `ceterisParibus` package to compute counterfactuals for a given
observation.
}
\examples{
\dontrun{
data(iris)
iris <- iris[iris$Species != "setosa", ]
iris$Species <- factor(iris$Species)
model <- fastml(data = iris, label = "Species")
counterfactual_explain(model, iris[1, ])
}
}
