% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{get_default_params}
\alias{get_default_params}
\title{Get Default Parameters for an Algorithm}
\usage{
get_default_params(algo, task, num_predictors = NULL, engine = NULL)
}
\arguments{
\item{algo}{A character string specifying the algorithm name. Supported values include:
\code{"rand_forest"}, \code{"C5_rules"}, \code{"xgboost"}, \code{"lightgbm"},
\code{"logistic_reg"}, \code{"multinom_reg"}, \code{"decision_tree"}, \code{"svm_linear"},
\code{"svm_rbf"}, \code{"nearest_neighbor"}, \code{"naive_Bayes"}, \code{"mlp"},
\code{"deep_learning"}, \code{"discrim_linear"}, \code{"discrim_quad"}, \code{"bag_tree"},
\code{"elastic_net"}, \code{"bayes_glm"}, \code{"pls"}, \code{"linear_reg"},
\code{"ridge_regression"}, and \code{"lasso_regression"}.}

\item{task}{A character string specifying the task type, typically \code{"classification"} or \code{"regression"}.}

\item{num_predictors}{An optional numeric value indicating the number of predictors. This value is used to compute default values for parameters such as \code{mtry}. Defaults to \code{NULL}.}

\item{engine}{An optional character string specifying the engine to use. If not provided, a default engine is chosen where applicable.}
}
\value{
A list of default parameter settings for the specified algorithm. If the algorithm is not recognized, the function returns \code{NULL}.
}
\description{
Returns a list of default tuning parameters for the specified algorithm based on the task type, number of predictors, and engine.
}
\details{
The function employs a \code{switch} statement to select and return a list of default parameters tailored for the given algorithm, task, and engine. The defaults vary by algorithm and, in some cases, by engine. For example:
  \itemize{
    \item For \code{"rand_forest"}, if \code{engine} is not provided, it defaults to \code{"ranger"}. The parameters such as \code{mtry}, \code{trees}, and \code{min_n} are computed based on the task and the number of predictors.
    \item For \code{"C5_rules"}, the defaults include \code{trees}, \code{min_n}, and \code{sample_size}.
    \item For \code{"xgboost"} and \code{"lightgbm"}, default values are provided for parameters like tree depth, learning rate, and sample size.
    \item For \code{"logistic_reg"} and \code{"multinom_reg"}, the function returns defaults for regularization parameters (\code{penalty} and \code{mixture}) that vary with the specified engine.
    \item For \code{"decision_tree"}, the parameters (such as \code{tree_depth}, \code{min_n}, and \code{cost_complexity}) are set based on the engine (e.g., \code{"rpart"}, \code{"C5.0"}, \code{"partykit"}, \code{"spark"}).
    \item Other algorithms, including \code{"svm_linear"}, \code{"svm_rbf"}, \code{"nearest_neighbor"}, \code{"naive_Bayes"}, \code{"mlp"}, \code{"deep_learning"}, \code{"elastic_net"}, \code{"bayes_glm"}, \code{"pls"}, \code{"linear_reg"}, \code{"ridge_regression"}, and \code{"lasso_regression"}, have their respective default parameter lists.
  }
}
