% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centroids.r
\name{centroids,GVector-method}
\alias{centroids,GVector-method}
\alias{centroids}
\alias{centroids,GRaster-method}
\title{Centroid(s) of a vector or clumps in a raster}
\usage{
\S4method{centroids}{GVector}(x, method = NULL)

\S4method{centroids}{GRaster}(x)
}
\arguments{
\item{x}{A \code{GVector} or \code{GRaster}.}

\item{method}{\code{GVector}s: Character or \code{NULL} (default): Method used for calculating centroids. The method of calculation depends on whether the input is a \code{points}, \code{lines}, or \code{polygons} \code{GVector}. If the value is \code{NULL}, then the default method will be chosen, depending on the geometry type of the \code{GVector}:
\itemize{
\item \code{points}:
\itemize{
\item \code{"mean"} (default for \code{points}): Mean of coordinates.
\item \code{"median"}: Geometric median; more robust to outliers.
\item \code{"pmedian"}: Point in \code{x} closest to the geometric median.
}
\item \code{lines}:
\itemize{
\item \code{"mid"} (default for \code{lines}): Mid-point on each line; will fall exactly on the line.
\item \code{"mean"}: Center of gravity of all line segments; may not fall on the line.
\item \verb{"median}: Geometric median; may not fall on the line.
}
\item \code{polygons}:
\itemize{
\item \code{"mean"} (default for \code{polygons}): Center of gravity (area), calculated using area triangulation.
\item \code{"median"}: Geometric mean; may not fall inside the polygon.
\item \code{"bmedian"}: Geometric mean; minimum distance to boundaries; may not fall inside the polygon.
}
}

Partial matching is used and case is ignored.}
}
\value{
If the input is a \code{GVector}, the output will be a "points" \code{GVector}. If the input is a \code{GRaster}, the output will be a "points" \code{GVector} with a table with statistics on each clump. If the input is a \code{GRaster} with more than one layer, the output will be a \code{list} of \code{GVector}s, with one \code{GVector} per layer.
}
\description{
This function locates the centroid of each geometry of a \code{GVector}, or the centroid of each "clump" of same-valued cells in an integer/categorical raster (for information on types of \code{GRaster}s, see \code{vignette("GRasters", package = "fasterRaster")}).

To use this function with a \code{GVector}, you need the \strong{GRASS} \code{v.centerpoint} addon. To use the function with a \code{GRaster}, you need the addon \code{r.centroids}. In either case, the function will try to install the respective addon (i.e., you need to have an internet connection). Once installed, a tool will not need to be installed again.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

### Points, line, and polygon centroids

# Point centroids:
madDypsis <- fastData("madDypsis")
dypsis <- fast(madDypsis)

dypMean <- centroids(dypsis)
dypMedian <- centroids(dypsis, method = "median")
dypPMedian <- centroids(dypsis, method = "pmedian")

plot(dypsis)
plot(dypMean, col = "red", add = TRUE)
plot(dypMedian, col = "green", pch = 2, add = TRUE)
plot(dypPMedian, col = "blue", pch = 3, add = TRUE)
legend("bottomright",
   legend = c("mean", "median", "pmedian"),
   col = c("red", "green", "blue"),
   pch = c(16, 2, 3),
   xpd = NA
)

# Line centroids:
madRivers <- fastData("madRivers")
rivers <- fast(madRivers)

riversMid <- centroids(rivers)
riversMean <- centroids(rivers, method = "mean")
riversMedian <- centroids(rivers, method = "median")

plot(rivers)
plot(riversMid, col = "red", add = TRUE)
plot(riversMean, col = "green", pch = 2, add = TRUE)
plot(riversMedian, col = "blue", pch = 3, add = TRUE)
legend("bottomright",
   legend = c("mid", "mean", "median"),
   col = c("red", "green", "blue"),
   pch = c(16, 2, 3),
   xpd = NA
)

# Polygon centroids:
madCoast4 <- fastData("madCoast4")
coast4 <- fast(madCoast4)

coastMean <- centroids(coast4)
coastMedian <- centroids(coast4, method = "median")
coastBMedian <- centroids(coast4, method = "bmedian")

plot(coast4)
plot(coastMean, col = "red", add = TRUE)
plot(coastMedian, col = "green", pch = 2, add = TRUE)
plot(coastBMedian, col = "blue", pch = 3, add = TRUE)
legend("bottomright",
   legend = c("mean", "median", "bmedian"),
   col = c("red", "green", "blue"),
   pch = c(16, 2, 1),
   xpd = NA
)

### Centroids of integer GRaster "clumps"

# Load elevation raster
madElev <- fastData("madElev")
elev <- fast(madElev)

# Create clumps of similarly-valued cells
clumps <- clump(elev, minDiff = 0.01, minClumpSize = 1000)

# Centroids:
clumpCents <- centroids(clumps)
clumpCents

plot(clumps)
plot(clumpCents, add = TRUE)


}
}
\seealso{
\code{\link[terra:centroids]{terra::centroids()}}; \strong{GRASS} addon tools \code{v.centerpoint} and \code{r.centroids}.
}
