% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.r
\name{mask,GRaster,GRaster-method}
\alias{mask,GRaster,GRaster-method}
\alias{mask}
\alias{mask,GRaster,GVector-method}
\title{Mask values in a raster}
\usage{
\S4method{mask}{GRaster,GRaster}(x, mask, inverse = FALSE, maskvalues = NA, updatevalue = NA)

\S4method{mask}{GRaster,GVector}(x, mask, inverse = FALSE, updatevalue = NA)
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{mask}{A \code{GRaster} or \code{GVector}.}

\item{inverse}{Logical: If \code{TRUE}, the effect of the mask is inverted. That is, a copy of the input raster is made, but cells that overlap with an \code{NA} in the mask raster or are not covered by the mask vector retain their values. Cells that overlap with an \code{NA} in the mask raster or overlap with the mask vector are forced to \code{NA}.}

\item{maskvalues}{Numeric vector, including \code{NA} (only for when \code{mask} is a \code{GRaster}): The value(s) in the mask raster cells that serve as the mask. The default is \code{NA}, in which case cells in the input raster that overlap with \code{NA} cells in the mask are forced to \code{NA}.}

\item{updatevalue}{Numeric, including \code{NA} (default): The values assigned to masked cells.}
}
\value{
A \code{GRaster}.
}
\description{
The output of \code{mask()} is a \code{GRaster} that has the same as values as the input raster. However, if the \code{mask} argument is a \code{GRaster}, the output will have \code{NA} values in the same cells that the \code{mask} raster has \code{NA} cells. If the \code{mask} argument is a \code{GVector}, then the output raster will have \code{NA} values in cells the \code{GVector} does not cover.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Example data
madElev <- fastData("madElev") # raster
madForest <- fastData("madForest2000") # raster
madCoast <- fastData("madCoast4") # vector

# Convert to GRasters and GVectors
elev <- fast(madElev)
forest <- fast(madForest)
coast <- fast(madCoast)

ant <- coast[coast$NAME_4 == "Antanambe"]

# Mask by a raster or  vector:
maskByRast <- mask(elev, forest)
plot(c(forest, maskByRast))

maskByVect <- mask(elev, ant)
plot(maskByVect)
plot(ant, add = TRUE)

# Mask by a raster or vector, but invert mask:
maskByRastInvert <- mask(elev, forest, inverse = TRUE)
plot(c(forest, maskByRastInvert))

maskByVectInvert <- mask(elev, ant, inverse = TRUE)
plot(maskByVectInvert)
plot(ant, add = TRUE)

# Mask by a raster, but use custom values for the mask:
maskByRastCustomMask <- mask(elev, elev, maskvalues = 1:20)
plot(c(elev <= 20, maskByRastCustomMask))

# Mask by a raster or vector, but force masked values to a custom value:
byRastCustomUpdate <- mask(elev, forest, updatevalue = 7)
plot(byRastCustomUpdate)

byVectCustomUpdate <- mask(elev, ant, updatevalue = 7)
plot(byVectCustomUpdate)

# Mask by a raster, inverse, custom values, and custom update:
byRastAll <-
   mask(elev, elev, inverse = TRUE, maskvalues = 1:20, updatevalue = 7)

plot(c(elev, byRastAll))

}
}
\seealso{
\code{\link[terra:mask]{terra::mask()}}, \strong{GRASS} module \code{r.mask}
}
