% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpIDW.r
\name{interpIDW,GVector,GRaster-method}
\alias{interpIDW,GVector,GRaster-method}
\alias{interpIDW}
\title{Interpolate values at points to a GRaster using inverse-distance weighting}
\usage{
\S4method{interpIDW}{GVector,GRaster}(x, y, field, nPoints = Inf, power = 2)
}
\arguments{
\item{x}{A "points" \code{GVector}.}

\item{y}{A \code{GRaster} to serve as a template for interpolation: Only points in \code{x} that fall inside the extent of the raster will be used for interpolation. You can increase the extent of a \code{GRaster} using \code{\link[=extend]{extend()}}.}

\item{field}{Character, integer, or numeric integer: Name or index of the column in \code{x} with values to interpolate. If \code{NULL} and if \code{x} is a 3-dimensional "points" \code{GVector}, then the interpolation will act on the z-coordinate of each point.}

\item{nPoints}{Integer or numeric integer: Number of nearest points to use for interpolation. The default is to use all points (\code{Inf}).}

\item{power}{Numeric value > 0: Power to which to take distance when interpolating. The default value is two, so the value of each point used for interpolation is \eqn{1 / d^2} where \emph{d} is distance.}
}
\value{
A \code{GRaster}.
}
\description{
This function interpolates values from a set of points to a raster using inverse distance weighting (IDW).
}
\seealso{
\code{\link[terra:interpIDW]{terra::interpIDW()}}, \code{\link[=interpSplines]{interpSplines()}}, \code{\link[=fillNAs]{fillNAs()}}, \strong{GRASS} module \code{v.surf.idw} (se \code{grassHelp("v.surf.idw")})
}
