% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undirected_planted_partition.R
\name{planted_partition}
\alias{planted_partition}
\title{Create an undirected planted partition object}
\usage{
planted_partition(
  n,
  k,
  ...,
  within_block = NULL,
  between_block = NULL,
  a = NULL,
  b = NULL,
  pi = rep(1/k, k),
  edge_distribution = c("poisson", "bernoulli"),
  sort_nodes = TRUE
)
}
\arguments{
\item{n}{The number of nodes in the network. Must be
a positive integer. This argument is required.}

\item{k}{Number of planted partitions, as a positive integer.
This argument is required.}

\item{...}{
  Arguments passed on to \code{\link[=undirected_factor_model]{undirected_factor_model}}
  \describe{
    \item{\code{expected_degree}}{If specified, the desired expected degree
of the graph. Specifying \code{expected_degree} simply rescales \code{S}
to achieve this. Defaults to \code{NULL}. Do not specify both
\code{expected_degree} and \code{expected_density} at the same time.}
    \item{\code{expected_density}}{If specified, the desired expected density
of the graph. Specifying \code{expected_density} simply rescales \code{S}
to achieve this. Defaults to \code{NULL}. Do not specify both
\code{expected_degree} and \code{expected_density} at the same time.}
  }}

\item{within_block}{Probability of within block edges. Must be
strictly between zero and one. Must specify either
\code{within_block} and \code{between_block}, or \code{a} and \code{b} to determine
edge probabilities.}

\item{between_block}{Probability of between block edges. Must be
strictly between zero and one. Must specify either
\code{within_block} and \code{between_block}, or \code{a} and \code{b} to determine
edge probabilities.}

\item{a}{Integer such that \code{a/n} is the probability of edges
within a block. Useful for sparse graphs. Must specify either
\code{within_block} and \code{between_block}, or \code{a} and \code{b} to determine
edge probabilities.}

\item{b}{Integer such that \code{b/n} is the probability of edges
between blocks. Useful for sparse graphs. Must specify either
\code{within_block} and \code{between_block}, or \code{a} and \code{b} to determine
edge probabilities.}

\item{pi}{(relative block probabilities) Relative block
probabilities. Must be positive, but do not need to sum
to one, as they will be normalized internally.
Must match the dimensions of \code{B} or \code{k}. Defaults to
\code{rep(1 / k, k)}, or a balanced blocks.}

\item{edge_distribution}{Either \code{"poisson"} or \code{"bernoulli"}. The
default is \code{"poisson"}, in which case the SBM can be a
multigraph, i.e. multiple edges between the same two nodes
are allowed. If \code{edge_distribution == "bernoulli"} only a
single edge is allowed between any pair of nodes. See Section 2.3
of Rohe et al (2017) for details.}

\item{sort_nodes}{Logical indicating whether or not to sort the nodes
so that they are grouped by block. Useful for plotting.
Defaults to \code{TRUE}.}
}
\value{
An \code{undirected_planted_partition} S3 object, which is a subclass
of the \code{\link[=sbm]{sbm()}} object, with additional fields:
\itemize{
\item \code{within_block}: The probability of edge formation within a block.
\item \code{between_block}: The probability of edge formation between two distinct
blocks.
}
}
\description{
To specify a planted partition model, you must specify
the number of nodes (via \code{n}), the mixing matrix (optional, either via
\code{within_block/between_block} or \code{a/b}),
and the relative block probabilites (optional, via \code{pi}).
We provide sane defaults for most of these options to enable
rapid exploration, or you can invest the effort
for more control over the model parameters. We \strong{strongly recommend}
setting the \code{expected_degree} or \code{expected_density} argument
to avoid large memory allocations associated with
sampling large, dense graphs.
}
\details{
A planted partition model is stochastic blockmodel in which
the diagonal and the off-diagonal of the mixing matrix \code{B}
are both constant. This means that edge probabilities
depend only on whether two nodes belong to the same block,
or to different blocks, but the particular blocks themselves
don't have any impact apart from this.
}
\examples{

set.seed(27)

lazy_pp <- planted_partition(
  n = 1000,
  k = 5,
  expected_density = 0.01,
  within_block = 0.1,
  between_block = 0.01
)

lazy_pp

}
\seealso{
Other stochastic block models: 
\code{\link{dcsbm}()},
\code{\link{sbm}()}

Other undirected graphs: 
\code{\link{dcsbm}()},
\code{\link{erdos_renyi}()},
\code{\link{sbm}()}
}
\concept{stochastic block models}
\concept{undirected graphs}
