% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{MathNoise}
\alias{MathNoise}
\title{Test performance and noise}
\format{
A data frame with 40 observations on the following 3 variables.
\itemize{ \item{score}{ score on a mathematics test}
\item{noise}{ a factor with levels \code{hi} \code{lo}}
\item{group}{ a factor with levels \code{control} \code{hyper}} }
}
\source{
Sydney S. Zentall and Jandira H. Shaw, Effects of classroom noise on
perfor- mance and activity of second-grade hyperactive and control children,
\emph{Journal of Educational Psychology} 72 (1980), no. 6, 830.
}
\description{
In this experiment, hyperactive and control students were given a
mathematics test in either a quiet or loud testing environment.
}
\examples{

data(MathNoise)
xyplot (score ~ noise, data = MathNoise, group = group, type = 'a', 
		auto.key = list(columns = 2, lines = TRUE, points = FALSE))

gf_jitter(score ~ noise, data = MathNoise, color = ~ group, alpha = 0.4, 
          width = 0.1, height = 0) \%>\%
  gf_line(score ~ noise, data = MathNoise, color = ~ group, group = ~ group,
        stat = "summary")
}
\keyword{datasets}
