% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{confusion_results}
\alias{confusion_results}
\title{Binary Confusion Table and Errors}
\usage{
confusion_results(yhat, ybin)
}
\arguments{
\item{yhat}{The binary predictions}

\item{ybin}{The true binary responses}
}
\value{
A list of raw results
}
\description{
Provides a binary confusion table and error metrics
}
\examples{
library(MASS); data(Pima.te)
ybin = as.numeric(Pima.te$type == "Yes")
flr = fast_logistic_regression(
  Xmm = model.matrix(~ . - type, Pima.te), 
  ybin = ybin
)
phat = predict(flr, model.matrix(~ . - type, Pima.te))
confusion_results(phat > 0.5, ybin)
}
