% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_annual_cumulative_stats.R
\name{calc_annual_cumulative_stats}
\alias{calc_annual_cumulative_stats}
\title{Calculate annual (and seasonal) total cumulative flows}
\usage{
calc_annual_cumulative_stats(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  use_yield = FALSE,
  basin_area,
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  months = 1:12,
  include_seasons = FALSE,
  transpose = FALSE,
  complete_years = FALSE
)
}
\arguments{
\item{data}{Data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{values}{Name of column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Name of column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required 
if groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if 
present. Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} 
argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{use_yield}{Logical value indicating whether to calculate area-based water yield, in mm, instead of volumetric discharge. 
Default \code{FALSE}.}

\item{basin_area}{Upstream drainage basin area, in square kilometres, to apply to observations. Three options:

(1) Leave blank if \code{groups} is STATION_NUMBER with HYDAT station numbers to extract basin areas from HYDAT.

(2) A single numeric value to apply to all observations.

(3) List each basin area for each group/station in groups (can override HYDAT value if listed) as such \code{c("08NM116" = 795, 
"08NM242" = 10)}. If group is not listed the HYDAT area will be applied if it exists, otherwise it will be \code{NA}.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank or set well before start date (i.e.
\code{1800}) to use from the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank or set well after end date (i.e.
\code{2100}) to use up to the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank or set to \code{NULL} to include all years.}

\item{months}{Numeric vector of months to include in analysis (e.g. \code{6:8} for Jun-Aug). Default summarizes all 
months (\code{1:12}). If not all months, seasonal total yield and volumetric flows will not be included.}

\item{include_seasons}{Logical value indication whether to include seasonal yields or volumetric discharges. Default \code{TRUE}.}

\item{transpose}{Logical value indicating whether to transpose rows and columns of results. Default \code{FALSE}.}

\item{complete_years}{Logical values indicating whether to include only years with complete data in analysis. Default \code{FALSE}.}
}
\value{
A tibble data frame with the following columns, ending with '_Volume_m3' or '_Yield_mm' based on selection:
  \item{Year}{calendar or water year selected}
  \item{Total_*}{annual (or selected months) total flow, in m3 or mm}
  Default seasonal columns:
  \item{MMM-MMM_*}{first of two season total flows, in m3 or mm}
  \item{MMM-MMM_*}{second of two season total flows, in m3 or mm}
  \item{MMM-MMM_*}{first of four season total flows, in m3 or mm}
  \item{MMM-MMM_*}{second of four season total flows, in m3 or mm}
  \item{MMM-MMM_*}{third of four season total flows, in m3 or mm}
  \item{MMM-MMM_*}{fourth of four season total flows, in m3 or mm}
  Transposing data creates a column of 'Statistics' and subsequent columns for each year selected.
}
\description{
Calculates annual and seasonal total flows, as volumetric discharge or water yields, from a daily streamflow data set.
   For water year and seasonal data, the year is identified by the year in which the year or season ends. Two-seasons and 
   four-seasons per year are calculated, with each 6 and 3-month seasons starting with the first month of the year (Jan for 
   calendar year, specified for water year). Each season is designated by the calendar or water year in which it occurs.
   Calculates statistics from all values from complete years, unless specified. Returns a tibble with statistics.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Calculate annual total volumetric flow statistics
calc_annual_cumulative_stats(station_number = "08NM116") 

# Calculate annual total yield statistics with default HYDAT basin area
calc_annual_cumulative_stats(station_number = "08NM116",
                             use_yield = TRUE) 

# Calculate annual total yield statistics with a custom basin area
calc_annual_cumulative_stats(station_number = "08NM116",
                             use_yield = TRUE,
                             basin_area = 800,
                             start_year = 1980) 
                             
}
}
